
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="squash_plants", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="chives", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="orange_trees", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7*x0**2 + 9*x0*x1 + 2*x2**2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23*x0 + 16*x1 >= 129, name="beauty_rating_squash_chives")
    model.addConstr(23**2*x0**2 + 13**2*x2**2 >= 84, name="beauty_rating_squash_orange")
    model.addConstr(23*x0 + 16*x1 + 13*x2 >= 84, name="total_beauty_rating")
    model.addConstr(9*x1 - 3*x2 >= 0, name="chives_orange_trees")
    model.addConstr(5*x0 - 7*x2 >= 0, name="squash_orange_trees")
    model.addConstr(23*x0 + 16*x1 <= 314, name="max_beauty_rating_squash_chives")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Squash Plants: ", x0.varValue)
        print("Chives: ", x1.varValue)
        print("Orange Trees: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
