
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")

# Set objective function
m.setObjective(5*george + 9*dale + 7*ringo + 8*laura + 5*paul + 6*hank, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*ringo + 23*paul >= 23)
m.addConstr(20*dale + 10*laura >= 37)
m.addConstr(10*laura + 22*hank >= 51)
m.addConstr(2*george + 20*dale >= 33)
m.addConstr(20*dale + 23*paul + 22*hank >= 35)
m.addConstr(2*george + 20*dale + 22*hank >= 35)
m.addConstr(2*george + 20*dale + 10*laura >= 35)
m.addConstr(20*dale + 23*paul + 22*hank >= 30)
m.addConstr(2*george + 20*dale + 22*hank >= 30)
m.addConstr(2*george + 20*dale + 10*laura >= 30)
m.addConstr(20*dale + 23*paul + 22*hank >= 48)
m.addConstr(2*george + 20*dale + 22*hank >= 48)
m.addConstr(2*george + 20*dale + 10*laura >= 48)
m.addConstr(2*george + 20*dale + 11*ringo + 10*laura + 23*paul + 22*hank >= 48)
m.addConstr(6*dale + 18*ringo >= 28)
m.addConstr(9*laura + 25*paul >= 22)
m.addConstr(6*dale + 25*paul >= 25)
m.addConstr(6*dale + 9*laura >= 21)
m.addConstr(25*paul + 8*hank >= 17)
m.addConstr(25*george + 6*dale + 18*ringo + 9*laura + 25*paul + 8*hank >= 17)
m.addConstr(10*george - 10*dale >= 0)
m.addConstr(10*laura + 23*paul <= 118)
m.addConstr(10*laura + 22*hank <= 74)
m.addConstr(20*dale + 22*hank <= 147)
m.addConstr(2*george + 10*laura + 23*paul <= 131)
m.addConstr(2*george + 11*ringo + 10*laura <= 146)
m.addConstr(2*george + 10*laura + 22*hank <= 215)
m.addConstr(2*george + 20*dale + 22*hank <= 252)
m.addConstr(9*laura + 25*paul <= 42)
m.addConstr(25*george + 6*dale <= 140)
m.addConstr(6*dale + 9*laura + 25*paul <= 64)
m.addConstr(9*laura + 25*paul + 8*hank <= 68)
m.addConstr(25*george + 9*laura + 25*paul <= 155)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
