
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_George = m.addVar(lb=0, name="hours_worked_by_George")
hours_worked_by_Dale = m.addVar(lb=0, name="hours_worked_by_Dale")
hours_worked_by_Ringo = m.addVar(lb=0, name="hours_worked_by_Ringo")
hours_worked_by_Laura = m.addVar(lb=0, name="hours_worked_by_Laura")
hours_worked_by_Paul = m.addVar(lb=0, name="hours_worked_by_Paul")
hours_worked_by_Hank = m.addVar(lb=0, name="hours_worked_by_Hank")

# Objective function
m.setObjective(5 * hours_worked_by_George + 9 * hours_worked_by_Dale + 7 * hours_worked_by_Ringo + 
               8 * hours_worked_by_Laura + 5 * hours_worked_by_Paul + 6 * hours_worked_by_Hank, gp.GRB.MINIMIZE)

# Constraints
# 1. The total combined dollar cost per hour from hours worked by Ringo plus hours worked by Paul should be 23 at minimum.
m.addConstraint(11 * hours_worked_by_Ringo + 23 * hours_worked_by_Paul >= 23)

# 2. The total combined dollar cost per hour from hours worked by Dale, and hours worked by Laura should be no less than 37.
m.addConstraint(20 * hours_worked_by_Dale + 10 * hours_worked_by_Laura >= 37)

# 3. The total combined dollar cost per hour from hours worked by Laura, and hours worked by Hank has to be 51 or more.
m.addConstraint(10 * hours_worked_by_Laura + 22 * hours_worked_by_Hank >= 51)

# 4. The total combined dollar cost per hour from hours worked by George, and hours worked by Dale must be 33 at a minimum.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale >= 33)

# 5. The total combined dollar cost per hour from hours worked by Dale, hours worked by Paul, and hours worked by Hank should be 35 or more.
m.addConstraint(20 * hours_worked_by_Dale + 23 * hours_worked_by_Paul + 22 * hours_worked_by_Hank >= 35)

# 6. The total combined dollar cost per hour from hours worked by George, hours worked by Dale, and hours worked by Hank has to be as much or more than 35.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 22 * hours_worked_by_Hank >= 35)

# 7. The total combined dollar cost per hour from hours worked by George, hours worked by Dale, and hours worked by Laura should be at least 35.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 10 * hours_worked_by_Laura >= 35)

# 8. The total combined dollar cost per hour from hours worked by Dale plus hours worked by Paul plus hours worked by Hank must be 30 or more.
m.addConstraint(20 * hours_worked_by_Dale + 23 * hours_worked_by_Paul + 22 * hours_worked_by_Hank >= 30)

# 9. The total combined dollar cost per hour from hours worked by George plus hours worked by Dale plus hours worked by Hank should be 30 or more.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 22 * hours_worked_by_Hank >= 30)

# 10. The total combined dollar cost per hour from hours worked by George plus hours worked by Dale plus hours worked by Laura must be at least 30.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 10 * hours_worked_by_Laura >= 30)

# 11. The total combined dollar cost per hour from hours worked by Dale plus hours worked by Paul plus hours worked by Hank must be 48 at minimum.
m.addConstraint(20 * hours_worked_by_Dale + 23 * hours_worked_by_Paul + 22 * hours_worked_by_Hank >= 48)

# 12. The total combined dollar cost per hour from hours worked by George plus hours worked by Dale plus hours worked by Hank should be 48 at minimum.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 22 * hours_worked_by_Hank >= 48)

# 13. The total combined dollar cost per hour from hours worked by George, hours worked by Dale, and hours worked by Laura should be 48 or more.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 10 * hours_worked_by_Laura >= 48)

# 14. The total combined dollar cost per hour from hours worked by George plus hours worked by Dale plus hours worked by Ringo plus hours worked by Laura plus hours worked by Paul plus hours worked by Hank should be greater than or equal to 48.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 11 * hours_worked_by_Ringo + 
               10 * hours_worked_by_Laura + 23 * hours_worked_by_Paul + 22 * hours_worked_by_Hank >= 48)

# 15. The total combined organization score from hours worked by Dale plus hours worked by Ringo has to be 28 or more.
m.addConstraint(6 * hours_worked_by_Dale + 18 * hours_worked_by_Ringo >= 28)

# 16. The total combined organization score from hours worked by Laura plus hours worked by Paul must be 22 or more.
m.addConstraint(9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul >= 22)

# 17. The total combined organization score from hours worked by Dale, and hours worked by Paul has to be at least 25.
m.addConstraint(6 * hours_worked_by_Dale + 25 * hours_worked_by_Paul >= 25)

# 18. The total combined organization score from hours worked by Dale plus hours worked by Laura should be 21 at minimum.
m.addConstraint(6 * hours_worked_by_Dale + 9 * hours_worked_by_Laura >= 21)

# 19. The total combined organization score from hours worked by Paul, and hours worked by Hank should be 17 or more.
m.addConstraint(25 * hours_worked_by_Paul + 8 * hours_worked_by_Hank >= 17)

# 20. The total combined organization score from hours worked by George plus hours worked by Dale plus hours worked by Ringo plus hours worked by Laura plus hours worked by Paul plus hours worked by Hank must be 17 at a minimum.
m.addConstraint(25 * hours_worked_by_George + 6 * hours_worked_by_Dale + 18 * hours_worked_by_Ringo + 
               9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul + 8 * hours_worked_by_Hank >= 17)

# 21. ten times the number of hours worked by George, plus -10 times the number of hours worked by Dale must be greater than or equal to zero.
m.addConstraint(10 * hours_worked_by_George - 10 * hours_worked_by_Dale >= 0)

# 22. The total combined dollar cost per hour from hours worked by Laura plus hours worked by Paul should be as much or less than 118.
m.addConstraint(10 * hours_worked_by_Laura + 23 * hours_worked_by_Paul <= 118)

# 23. The total combined dollar cost per hour from hours worked by Laura, and hours worked by Hank must be  no more than 74.
m.addConstraint(10 * hours_worked_by_Laura + 22 * hours_worked_by_Hank <= 74)

# 24. The total combined dollar cost per hour from hours worked by Dale and hours worked by Hank must be 147 or less.
m.addConstraint(20 * hours_worked_by_Dale + 22 * hours_worked_by_Hank <= 147)

# 25. The total combined dollar cost per hour from hours worked by George, hours worked by Laura and hours worked by Paul should be at most 131.
m.addConstraint(2 * hours_worked_by_George + 10 * hours_worked_by_Laura + 23 * hours_worked_by_Paul <= 131)

# 26. The total combined dollar cost per hour from hours worked by George plus hours worked by Ringo plus hours worked by Laura must be at most 146.
m.addConstraint(2 * hours_worked_by_George + 11 * hours_worked_by_Ringo + 10 * hours_worked_by_Laura <= 146)

# 27. The total combined dollar cost per hour from hours worked by George, hours worked by Laura, and hours worked by Hank must be 215 at maximum.
m.addConstraint(2 * hours_worked_by_George + 10 * hours_worked_by_Laura + 22 * hours_worked_by_Hank <= 215)

# 28. The total combined dollar cost per hour from hours worked by George plus hours worked by Dale plus hours worked by Hank has to be at most 252.
m.addConstraint(2 * hours_worked_by_George + 20 * hours_worked_by_Dale + 22 * hours_worked_by_Hank <= 252)

# 29. The total combined organization score from hours worked by Laura plus hours worked by Paul must be at most 42.
m.addConstraint(9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul <= 42)

# 30. The total combined organization score from hours worked by George plus hours worked by Dale must be 140 at maximum.
m.addConstraint(25 * hours_worked_by_George + 6 * hours_worked_by_Dale <= 140)

# 31. The total combined organization score from hours worked by Dale, hours worked by Laura and hours worked by Paul must be equal to or less than 64.
m.addConstraint(6 * hours_worked_by_Dale + 9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul <= 64)

# 32. The total combined organization score from hours worked by Laura plus hours worked by Paul plus hours worked by Hank has to be equal to or less than 68.
m.addConstraint(9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul + 8 * hours_worked_by_Hank <= 68)

# 33. The total combined organization score from hours worked by George, hours worked by Laura, and hours worked by Paul has to be 155 at maximum.
m.addConstraint(25 * hours_worked_by_George + 9 * hours_worked_by_Laura + 25 * hours_worked_by_Paul <= 155)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by Dale: ", hours_worked_by_Dale.varValue)
    print("Hours worked by Ringo: ", hours_worked_by_Ringo.varValue)
    print("Hours worked by Laura: ", hours_worked_by_Laura.varValue)
    print("Hours worked by Paul: ", hours_worked_by_Paul.varValue)
    print("Hours worked by Hank: ", hours_worked_by_Hank.varValue)
else:
    print("The model is infeasible.")
