
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b9 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B9")  # milligrams of vitamin B9
b5 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B5")  # milligrams of vitamin B5

# Set objective function
model.setObjective(1.18 * b9 + 8.37 * b5, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * b9 + 5 * b5 >= 31, "immune_support_min")
model.addConstr(14 * b9 + 13 * b5 >= 21, "energy_stability_min")
model.addConstr(4 * b9 + 6 * b5 >= 42, "digestive_support_min")

model.addConstr(-7 * b9 + 8 * b5 >= 0, "b9_b5_relation")

model.addConstr(7 * b9 + 5 * b5 <= 101, "immune_support_max")
model.addConstr(14 * b9 + 13 * b5 <= 61, "energy_stability_max")
model.addConstr(4 * b9 + 6 * b5 <= 113, "digestive_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Milligrams of Vitamin B9: {b9.x}")
    print(f"Milligrams of Vitamin B5: {b5.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

