
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_B9")  # Vitamin B9
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B5")  # Vitamin B5

# Objective function: Maximize 1.18*x0 + 8.37*x1
m.setObjective(1.18*x0 + 8.37*x1, GRB.MAXIMIZE)

# Constraints
# Combined immune support index must be at least 31 and no more than 101
m.addConstr(7*x0 + 5*x1 >= 31, name="immune_support_min")
m.addConstr(7*x0 + 5*x1 <= 101, name="immune_support_max")

# Combined energy stability index must be at least 21 and no more than 61
m.addConstr(14*x0 + 13*x1 >= 21, name="energy_stability_min")
m.addConstr(14*x0 + 13*x1 <= 61, name="energy_stability_max")

# Combined digestive support index must be at least 42 and no more than 113
m.addConstr(4*x0 + 6*x1 >= 42, name="digestive_support_min")
m.addConstr(4*x0 + 6*x1 <= 113, name="digestive_support_max")

# Additional constraint: -7x0 + 8x1 >= 0
m.addConstr(-7*x0 + 8*x1 >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B9: {x0.x}")
    print(f"Milligrams of Vitamin B5: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
