
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_B9", lb=0)  # Vitamin B9
    x1 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)  # Vitamin B5

    # Objective function: Maximize 1.18x0 + 8.37x1
    model.setObjective(1.18 * x0 + 8.37 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x0 + 5 * x1 >= 31, name="immune_support_min")
    model.addConstr(7 * x0 + 5 * x1 <= 101, name="immune_support_max")
    model.addConstr(14 * x0 + 13 * x1 >= 21, name="energy_stability_min")
    model.addConstr(14 * x0 + 13 * x1 <= 61, name="energy_stability_max")
    model.addConstr(4 * x0 + 6 * x1 >= 42, name="digestive_support_min")
    model.addConstr(4 * x0 + 6 * x1 <= 113, name="digestive_support_max")
    model.addConstr(-7 * x0 + 8 * x1 >= 0, name="additional_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of Vitamin B9: {x0.x}")
        print(f"Milligrams of Vitamin B5: {x1.x}")
        print(f"Objective: {model.objval}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
