
import gurobipy as gp

# Create a new model
m = gp.Model("office_supplies")

# Create variables
staplers = m.addVar(vtype=gp.GRB.INTEGER, name="staplers")
headsets = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")
planners = m.addVar(vtype=gp.GRB.INTEGER, name="planners")
blue_pens = m.addVar(vtype=gp.GRB.INTEGER, name="blue_pens")
office_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="office_chairs")
smoke_detectors = m.addVar(vtype=gp.GRB.INTEGER, name="smoke_detectors")

# Set objective function
m.setObjective(7.67 * staplers + 1.84 * headsets + 4.52 * planners + 8.41 * blue_pens + 6.13 * office_chairs + 4.21 * smoke_detectors, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * headsets + 12 * blue_pens >= 24, "c1")
m.addConstr(staplers + 12 * blue_pens >= 18, "c2")
m.addConstr(14 * headsets + 8 * planners + 7 * office_chairs >= 23, "c3")
m.addConstr(4 * headsets + planners >= 14, "c4")
m.addConstr(planners + 4 * blue_pens >= 35, "c5")
m.addConstr(staplers + planners >= 26, "c6")
m.addConstr(4 * blue_pens + 10 * office_chairs >= 33, "c7")
m.addConstr(planners + 10 * office_chairs >= 36, "c8")
m.addConstr(4 * headsets + 13 * smoke_detectors >= 42, "c9")
m.addConstr(10 * office_chairs + 13 * smoke_detectors >= 25, "c10")
m.addConstr(staplers + 10 * office_chairs >= 21, "c11")
m.addConstr(staplers + 8 * planners <= 104, "c12")
m.addConstr(staplers + 7 * smoke_detectors <= 84, "c13")
m.addConstr(8 * planners + 12 * blue_pens <= 150, "c14")
m.addConstr(7 * office_chairs + 7 * smoke_detectors <= 188, "c15")
m.addConstr(12 * blue_pens + 7 * office_chairs <= 81, "c16")
m.addConstr(staplers + 14 * headsets <= 122, "c17")
m.addConstr(14 * headsets + 8 * planners <= 137, "c18")
m.addConstr(staplers + 7 * office_chairs <= 105, "c19")
m.addConstr(14 * headsets + 12 * blue_pens <= 92, "c20")
m.addConstr(staplers + headsets + planners + blue_pens + office_chairs + smoke_detectors <= 92, "c21")
m.addConstr(planners + 13 * smoke_detectors <= 117, "c22")
m.addConstr(planners + 10 * office_chairs <= 206, "c23")
m.addConstr(staplers + 13 * smoke_detectors <= 61, "c24")
m.addConstr(4 * blue_pens + 13 * smoke_detectors <= 115, "c25")
m.addConstr(10 * office_chairs + 13 * smoke_detectors <= 136, "c26")
m.addConstr(staplers + 4 * headsets <= 222, "c27")
m.addConstr(planners + 4 * blue_pens <= 145, "c28")
m.addConstr(4 * headsets + 13 * smoke_detectors <= 159, "c29")
m.addConstr(staplers + planners <= 51, "c30")
m.addConstr(staplers + headsets + planners + blue_pens + office_chairs + smoke_detectors <= 51, "c31")


# Resource constraints (given in the problem description)
m.addConstr(staplers + 14*headsets + 8*planners + 12*blue_pens + 7*office_chairs + 7*smoke_detectors <= 188, "sustainability")
m.addConstr(staplers + 4*headsets + planners + 4*blue_pens + 10*office_chairs + 13*smoke_detectors <= 260, "safety")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

