
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    staplers = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="staplers")
    headsets = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="headsets")
    planners = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="planners")
    blue_pens = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="blue_pens")
    office_chairs = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="office_chairs")
    smoke_detectors = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="smoke_detectors")

    # Objective function
    model.setObjective(7.67 * staplers + 1.84 * headsets + 4.52 * planners + 8.41 * blue_pens + 6.13 * office_chairs + 4.21 * smoke_detectors, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Sustainability score constraints
    model.addConstr(14 * headsets + 12 * blue_pens >= 24, name="sustainability_score_headsets_blue_pens")
    model.addConstr(staplers + 12 * blue_pens >= 18, name="sustainability_score_staplers_blue_pens")
    model.addConstr(14 * headsets + 8 * planners + 7 * office_chairs >= 23, name="sustainability_score_headsets_planners_office_chairs")
    model.addConstr(staplers + 8 * planners <= 104, name="sustainability_score_staplers_planners")
    model.addConstr(staplers + 7 * smoke_detectors <= 84, name="sustainability_score_staplers_smoke_detectors")
    model.addConstr(8 * planners + 12 * blue_pens <= 150, name="sustainability_score_planners_blue_pens")
    model.addConstr(7 * office_chairs + 7 * smoke_detectors <= 188, name="sustainability_score_office_chairs_smoke_detectors")
    model.addConstr(12 * blue_pens + 7 * office_chairs <= 81, name="sustainability_score_blue_pens_office_chairs")
    model.addConstr(staplers + 14 * headsets <= 122, name="sustainability_score_staplers_headsets")
    model.addConstr(14 * headsets + 8 * planners <= 137, name="sustainability_score_headsets_planners")
    model.addConstr(staplers + 7 * office_chairs <= 105, name="sustainability_score_staplers_office_chairs")
    model.addConstr(14 * headsets + 12 * blue_pens <= 92, name="sustainability_score_headsets_blue_pens_2")
    model.addConstr(staplers + 14 * headsets + 8 * planners + 12 * blue_pens + 7 * office_chairs + 7 * smoke_detectors <= 92, name="sustainability_score_all")

    # Workplace safety impact constraints
    model.addConstr(4 * headsets + planners >= 14, name="workplace_safety_impact_headsets_planners")
    model.addConstr(4 * blue_pens + planners >= 35, name="workplace_safety_impact_blue_pens_planners")
    model.addConstr(staplers + planners >= 26, name="workplace_safety_impact_staplers_planners")
    model.addConstr(4 * blue_pens + 10 * office_chairs >= 33, name="workplace_safety_impact_blue_pens_office_chairs")
    model.addConstr(planners + 10 * office_chairs >= 36, name="workplace_safety_impact_planners_office_chairs")
    model.addConstr(4 * headsets + 13 * smoke_detectors >= 42, name="workplace_safety_impact_headsets_smoke_detectors")
    model.addConstr(10 * office_chairs + 13 * smoke_detectors >= 25, name="workplace_safety_impact_office_chairs_smoke_detectors")
    model.addConstr(staplers + 10 * office_chairs >= 21, name="workplace_safety_impact_staplers_office_chairs")
    model.addConstr(planners + 13 * smoke_detectors <= 117, name="workplace_safety_impact_planners_smoke_detectors")
    model.addConstr(planners + 10 * office_chairs <= 206, name="workplace_safety_impact_planners_office_chairs_2")
    model.addConstr(staplers + 13 * smoke_detectors <= 61, name="workplace_safety_impact_staplers_smoke_detectors")
    model.addConstr(4 * blue_pens + 13 * smoke_detectors <= 115, name="workplace_safety_impact_blue_pens_smoke_detectors")
    model.addConstr(10 * office_chairs + 13 * smoke_detectors <= 136, name="workplace_safety_impact_office_chairs_smoke_detectors_2")
    model.addConstr(staplers + 4 * headsets <= 222, name="workplace_safety_impact_staplers_headsets")
    model.addConstr(planners + 4 * blue_pens <= 145, name="workplace_safety_impact_planners_blue_pens")
    model.addConstr(4 * headsets + 13 * smoke_detectors <= 159, name="workplace_safety_impact_headsets_smoke_detectors_2")
    model.addConstr(staplers + planners <= 51, name="workplace_safety_impact_staplers_planners_2")
    model.addConstr(staplers + 4 * headsets + planners + 4 * blue_pens + 10 * office_chairs + 13 * smoke_detectors <= 51, name="workplace_safety_impact_all")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Staplers: ", staplers.varValue)
        print("Headsets: ", headsets.varValue)
        print("Planners: ", planners.varValue)
        print("Blue Pens: ", blue_pens.varValue)
        print("Office Chairs: ", office_chairs.varValue)
        print("Smoke Detectors: ", smoke_detectors.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
