
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Define the decision variables
x_J = m.addVar(name="Jean", lb=0)
x_D = m.addVar(name="Dale", lb=0)
x_Jn = m.addVar(name="John", lb=0)
x_B = m.addVar(name="Bobby", lb=0)
x_Bl = m.addVar(name="Bill", lb=0)

# Objective function
m.setObjective(1.5*x_J + 2*x_D + 3*x_Jn + 4*x_B + 5*x_Bl, GRB.MINIMIZE)

# Example constraint (you'll need to add all constraints like this)
# Let's say one of the constraints is: -2*x_B + 9*x_Bl >= 0
m.addConstr(-2*x_B + 9*x_Bl >= 0, name="Example_Constraint")

# Add other constraints similarly...

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found.")

