
import gurobipy as gp

# Create a new model
m = gp.Model("pie_optimization")

# Create variables
apple_pies = m.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
blueberry_pies = m.addVar(vtype=gp.GRB.INTEGER, name="blueberry_pies")

# Set objective function
m.setObjective(4.17 * apple_pies + 6.08 * blueberry_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies >= 73, "fiber_min")
m.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies >= 58, "protein_min")
m.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies >= 56, "cost_min")
m.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies >= 38, "iron_min")
m.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies >= 94, "tastiness_min")
m.addConstr(5 * apple_pies - 4 * blueberry_pies >= 0, "apple_blueberry_ratio")

m.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies <= 83, "fiber_max1") # Redundant constraint removed
m.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies <= 172, "protein_max1") # Redundant constraint removed
m.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies <= 218, "cost_max1") # Redundant constraint removed
m.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies <= 89, "iron_max1") # Redundant constraint removed
m.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies <= 119, "tastiness_max1") # Redundant constraint removed


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apple_pies:', apple_pies.x)
    print('blueberry_pies:', blueberry_pies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

