
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x1 = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Objective function: Maximize 4.17*x0 + 6.08*x1
m.setObjective(4.17*x0 + 6.08*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(3.95*x0 + 6.48*x1 >= 73, name="fiber_min")
m.addConstr(3.95*x0 + 6.48*x1 <= 83, name="fiber_max")
m.addConstr(12.08*x0 + 1.48*x1 >= 58, name="protein_min")
m.addConstr(12.08*x0 + 1.48*x1 <= 172, name="protein_max")
m.addConstr(13.27*x0 + 7.25*x1 >= 56, name="cost_min")
m.addConstr(13.27*x0 + 7.25*x1 <= 218, name="cost_max")
m.addConstr(12.13*x0 + 12.43*x1 >= 38, name="iron_min")
m.addConstr(12.13*x0 + 12.43*x1 <= 89, name="iron_max")
m.addConstr(12.81*x0 + 2.93*x1 >= 94, name="tastiness_min")
m.addConstr(12.81*x0 + 2.93*x1 <= 119, name="tastiness_max")
m.addConstr(5*x0 - 4*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Pies: {x0.x}")
    print(f"Blueberry Pies: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
