
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    apple_pies = model.addVar(name="apple_pies", integer=True)
    blueberry_pies = model.addVar(name="blueberry_pies", integer=True)

    # Objective function
    model.setObjective(4.17 * apple_pies + 6.08 * blueberry_pies, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies <= 164, name="fiber_upper")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies <= 197, name="protein_upper")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies <= 229, name="cost_upper")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies <= 117, name="iron_upper")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies <= 203, name="tastiness_upper")

    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies >= 73, name="fiber_lower")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies >= 58, name="protein_lower")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies >= 56, name="cost_lower")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies >= 38, name="iron_lower")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies >= 94, name="tastiness_lower")

    model.addConstr(5 * apple_pies - 4 * blueberry_pies >= 0, name="pie_balance")

    model.addConstr(3.95 * apple_pies + 6.48 * blueberry_pies <= 83, name="fiber_tight_upper")
    model.addConstr(12.08 * apple_pies + 1.48 * blueberry_pies <= 172, name="protein_tight_upper")
    model.addConstr(13.27 * apple_pies + 7.25 * blueberry_pies <= 218, name="cost_tight_upper")
    model.addConstr(12.13 * apple_pies + 12.43 * blueberry_pies <= 89, name="iron_tight_upper")
    model.addConstr(12.81 * apple_pies + 2.93 * blueberry_pies <= 119, name="tastiness_tight_upper")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Apple Pies: ", apple_pies.varValue)
        print("Blueberry Pies: ", blueberry_pies.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
