
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
john_hours = model.addVar(vtype=GRB.INTEGER, name="john_hours")
peggy_hours = model.addVar(vtype=GRB.INTEGER, name="peggy_hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="mary_hours")

# Set objective function
model.setObjective(2.18 * john_hours + 6.25 * peggy_hours + 8.27 * mary_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * john_hours + 4 * peggy_hours + 18 * mary_hours >= 36, "computer_competence_min")
model.addConstr(19 * john_hours + 13 * peggy_hours <= 46, "dollar_cost_john_peggy_max")  # Corrected constraint
model.addConstr(6 * john_hours + 18 * mary_hours <= 75, "computer_competence_john_mary_max")
model.addConstr(6 * john_hours + 4 * peggy_hours + 18 * mary_hours <= 102, "computer_competence_max") # Combined redundant constraints
model.addConstr(11 * peggy_hours + 6 * mary_hours <= 48, "productivity_peggy_mary_max")
model.addConstr(1 * john_hours + 6 * mary_hours <= 74, "productivity_john_mary_max")
model.addConstr(1 * john_hours + 11 * peggy_hours + 6 * mary_hours <= 98, "productivity_max") # Combined redundant constraints
model.addConstr(19 * john_hours + 7 * mary_hours <= 131, "dollar_cost_john_mary_max")
model.addConstr(19 * john_hours + 13 * peggy_hours + 7 * mary_hours <= 134, "dollar_cost_max") # Combined redundant constraints


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('John Hours: %g' % john_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

