
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Peggy", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2.18*x0 + 6.25*x1 + 8.27*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x0 + 4*x1 + 18*x2 >= 36)
    model.addConstr(19*x0 + 13*x1 >= 27)
    model.addConstr(6*x0 + 18*x2 <= 75)
    model.addConstr(6*x0 + 4*x1 + 18*x2 <= 102)
    model.addConstr(11*x1 + 6*x2 <= 48)
    model.addConstr(x0 + 6*x2 <= 74)
    model.addConstr(x0 + 11*x1 + 6*x2 <= 98)
    model.addConstr(19*x0 + 13*x1 <= 46)
    model.addConstr(19*x0 + 7*x2 <= 131)
    model.addConstr(19*x0 + 13*x1 + 7*x2 <= 134)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by John: {x0.varValue}")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Mary: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
