
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
ham_sandwiches = m.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")
bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")
black_beans = m.addVar(vtype=GRB.INTEGER, name="black_beans")

# Objective function
m.setObjective(7.18 * ham_sandwiches * bowls_of_cereal + 6.24 * bowls_of_cereal**2 + 6.71 * bowls_of_cereal * black_beans, GRB.MINIMIZE)

# Constraints
m.addConstr(8 * ham_sandwiches + 10 * bowls_of_cereal >= 26, name="protein_min_1")
m.addConstr(8 * ham_sandwiches + 13 * black_beans >= 26, name="protein_min_2")
m.addConstr(10 * bowls_of_cereal + 13 * black_beans >= 34, name="protein_min_3")
m.addConstr(8 * ham_sandwiches + 10 * bowls_of_cereal + 13 * black_beans >= 34, name="total_protein_min")

m.addConstr(4 * ham_sandwiches - 3 * black_beans >= 0, name="other_constraint_1")
m.addConstr(10 * bowls_of_cereal + 13 * black_beans <= 97, name="protein_max_1")
m.addConstr(8 * ham_sandwiches + 10 * bowls_of_cereal <= 78, name="protein_max_2")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ham Sandwiches: {ham_sandwiches.x}")
    print(f"Bowls of Cereal: {bowls_of_cereal.x}")
    print(f"Black Beans: {black_beans.x}")
else:
    print("No optimal solution found")
