
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="ham_sandwiches", vtype=gp.GRB.INTEGER)  # ham sandwiches
x1 = m.addVar(name="bowls_of_cereal", vtype=gp.GRB.INTEGER)  # bowls of cereal
x2 = m.addVar(name="black_beans", vtype=gp.GRB.INTEGER)  # black beans

# Objective function
m.setObjective(7.18 * x0 * x1 + 6.24 * x1 ** 2 + 6.71 * x1 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8 * x0 + 10 * x1 >= 26, name="protein_ham_cereal")
m.addConstr(8 * x0 + 13 * x2 >= 26, name="protein_ham_beans")
m.addConstr(10 * x1 + 13 * x2 >= 34, name="protein_cereal_beans")
m.addConstr(8 * x0 + 10 * x1 + 13 * x2 >= 34, name="protein_all")
m.addConstr(4 * x0 - 3 * x2 >= 0, name="ham_vs_beans")
m.addConstr(10 * x1 + 13 * x2 <= 97, name="max_protein_cereal_beans")
m.addConstr(8 * x0 + 10 * x1 <= 78, name="max_protein_ham_cereal")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("ham sandwiches: ", x0.varValue)
    print("bowls of cereal: ", x1.varValue)
    print("black beans: ", x2.varValue)
else:
    print("The model is infeasible")
