
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="grams_of_protein")

# Define the objective function
m.setObjective(8.27 * x0 + 9.25 * x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(2.3 * x0 + 0.28 * x1 >= 22, "muscle_growth_index_constraint")
m.addConstr(0.95 * x0 + 1.94 * x1 >= 15, "energy_stability_index_constraint")
m.addConstr(2.92 * x0 + 0.58 * x1 >= 12, "immune_support_index_constraint")
m.addConstr(-8 * x0 + 10 * x1 >= 0, "additional_linear_constraint")
m.addConstr(2.3 * x0 + 0.28 * x1 <= 55, "muscle_growth_upper_bound")
m.addConstr(0.95 * x0 + 1.94 * x1 <= 60, "energy_stability_upper_bound")
m.addConstr(2.92 * x0 + 0.58 * x1 <= 44, "immune_support_upper_bound")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin D: {x0.x}")
    print(f"Grams of Protein: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
