
import gurobi

def optimize_vitamin_d_protein():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    vitamin_d = model.addVar(lb=0, name="vitamin_d")  # Fractional
    protein = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="protein")  # Integer

    # Objective function
    model.setObjective(8.27 * vitamin_d + 9.25 * protein, gurobi.GRB.MINIMIZE)

    # Constraints
    # Indices
    r0_vitamin_d = 2.3
    r1_vitamin_d = 0.95
    r2_vitamin_d = 2.92
    r0_protein = 0.28
    r1_protein = 1.94
    r2_protein = 0.58

    # Total combined muscle growth index >= 22
    model.addConstraint(r0_vitamin_d * vitamin_d + r0_protein * protein >= 22, name="muscle_growth_min")

    # Total combined energy stability index >= 15
    model.addConstraint(r1_vitamin_d * vitamin_d + r1_protein * protein >= 15, name="energy_stability_min")

    # Total combined immune support index >= 12
    model.addConstraint(r2_vitamin_d * vitamin_d + r2_protein * protein >= 12, name="immune_support_min")

    # -8 * vitamin_d + 10 * protein >= 0
    model.addConstraint(-8 * vitamin_d + 10 * protein >= 0, name="vitamin_d_protein_tradeoff")

    # Total combined muscle growth index <= 55
    model.addConstraint(r0_vitamin_d * vitamin_d + r0_protein * protein <= 55, name="muscle_growth_max")

    # Total combined energy stability index <= 60
    model.addConstraint(r1_vitamin_d * vitamin_d + r1_protein * protein <= 60, name="energy_stability_max")

    # Total combined immune support index <= 44
    model.addConstraint(r2_vitamin_d * vitamin_d + r2_protein * protein <= 44, name="immune_support_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Vitamin D: {vitamin_d.varValue}")
        print(f"Grams of Protein: {protein.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_vitamin_d_protein()
