
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Hours_Optimization")

# Create variables
laura = model.addVar(vtype=GRB.INTEGER, name="laura")
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
john = model.addVar(name="john")
paul = model.addVar(vtype=GRB.INTEGER, name="paul")
hank = model.addVar(vtype=GRB.INTEGER, name="hank")
george = model.addVar(vtype=GRB.INTEGER, name="george")

# Set objective function
model.setObjective(9.65 * laura * ringo + 7.47 * laura * john + 6.82 * laura * hank + 6.51 * laura * george + 7.67 * ringo * ringo + 3.64 * ringo * hank + 1.08 * ringo * george + 9.24 * john * john + 9.39 * john * hank + 1.46 * john * george + 8.24 * paul * paul + 7.27 * paul * george + 9.2 * hank * hank + 6.82 * hank * george + 1.5 * george * george + 9.53 * ringo + 1.88 * john + 8.03 * hank + 6.24 * george, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * ringo * ringo + 1 * paul * paul + 10 * george * george >= 15)
model.addConstr(6 * laura + 11 * john + 7 * hank >= 15)
model.addConstr(6 * laura * laura + 9 * ringo * ringo + 1 * paul * paul >= 15)
model.addConstr(9 * ringo * ringo + 1 * paul * paul + 10 * george * george >= 18)
model.addConstr(6 * laura + 11 * john + 7 * hank >= 18)
model.addConstr(6 * laura * laura + 9 * ringo * ringo + 1 * paul * paul >= 18)
model.addConstr(9 * ringo * ringo + 1 * paul * paul + 10 * george * george >= 10)
model.addConstr(6 * laura + 11 * john + 7 * hank >= 10)
model.addConstr(6 * laura * laura + 9 * ringo * ringo + 1 * paul * paul >= 10)
model.addConstr(6 * john - 3 * george >= 0)
model.addConstr(9 * ringo * ringo + 1 * paul * paul <= 47)
model.addConstr(9 * ringo * ringo + 10 * george * george <= 63)
model.addConstr(6 * laura + 10 * george <= 56)
model.addConstr(7 * hank + 10 * george <= 111)
model.addConstr(6 * laura * laura + 9 * ringo * ringo <= 62)
model.addConstr(6 * laura + 11 * john <= 110)
model.addConstr(11 * john + 1 * paul <= 28)
model.addConstr(9 * ringo + 11 * john + 1 * paul <= 97)
model.addConstr(6 * laura + 1 * paul + 7 * hank <= 74)
model.addConstr(6 * laura + 9 * ringo + 11 * john + 1 * paul + 7 * hank + 10 * george <= 74)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
