
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
L = m.addVar(lb=6, ub=6, vtype=gp.GRB.INTEGER, name="L")
R = m.addVar(lb=9, ub=9, vtype=gp.GRB.INTEGER, name="R")
J = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="J")
P = m.addVar(lb=1, ub=1, vtype=gp.GRB.INTEGER, name="P")
H = m.addVar(lb=7, ub=7, vtype=gp.GRB.INTEGER, name="H")
G = m.addVar(lb=10, ub=10, vtype=gp.GRB.INTEGER, name="G")

# Objective function
m.setObjective(9.65*L*R + 7.47*L*J + 6.82*L*H + 6.51*L*G + 
               7.67*R**2 + 3.64*R*H + 1.08*R*G + 9.24*J**2 + 
               9.39*J*H + 1.46*J*G + 8.24*P**2 + 7.27*P*G + 
               9.2*H**2 + 6.82*H*G + 1.5*G**2 + 9.53*R + 
               1.88*J + 8.03*H + 6.24*G, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(R**2 + P**2 + G**2 >= 15, name="c7")
m.addConstr(L + J + H >= 15, name="c8")
m.addConstr(L**2 + R**2 + P**2 >= 15, name="c9")
m.addConstr(R**2 + P**2 + G**2 >= 18, name="c10")
m.addConstr(L + J + H >= 18, name="c11")
m.addConstr(L**2 + R**2 + P**2 >= 18, name="c12")
m.addConstr(R**2 + P**2 + G**2 >= 10, name="c13")
m.addConstr(L + J + H >= 10, name="c14")
m.addConstr(L**2 + R**2 + P**2 >= 10, name="c15")
m.addConstr(6*J - 3*G >= 0, name="c16")
m.addConstr(R**2 + P**2 <= 47, name="c17")
m.addConstr(R**2 + G**2 <= 63, name="c18")
m.addConstr(L + G <= 56, name="c19")
m.addConstr(H + G <= 111, name="c20")
m.addConstr(L**2 + R**2 <= 62, name="c21")
m.addConstr(L + J <= 110, name="c22")
m.addConstr(J + P <= 28, name="c23")
m.addConstr(R + J + P <= 97, name="c24")
m.addConstr(L + P + H <= 74, name="c25")
m.addConstr(L + R + J + P + H + G <= 74, name="c26")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("L: ", L.varValue)
    print("R: ", R.varValue)
    print("J: ", J.varValue)
    print("P: ", P.varValue)
    print("H: ", H.varValue)
    print("G: ", G.varValue)
else:
    print("The model is infeasible")
