
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hour Optimization")

# Create variables
george_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="George_Hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peggy_Hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura_Hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary_Hours")

# Set objective function
model.setObjective(5 * george_hours + peggy_hours + 9 * laura_hours + 4 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * peggy_hours + 29 * mary_hours >= 76, "c1")
model.addConstr(13 * george_hours + 4 * peggy_hours >= 45, "c2")
model.addConstr(13 * george_hours + 6 * laura_hours >= 82, "c3")
model.addConstr(13 * george_hours + 29 * mary_hours >= 60, "c4")
model.addConstr(6 * laura_hours + 29 * mary_hours >= 59, "c5")
model.addConstr(4 * peggy_hours + 6 * laura_hours + 29 * mary_hours >= 58, "c6")
model.addConstr(13 * george_hours + 6 * laura_hours + 29 * mary_hours >= 58, "c7")
model.addConstr(4 * peggy_hours + 6 * laura_hours + 29 * mary_hours >= 57, "c8")
model.addConstr(13 * george_hours + 6 * laura_hours + 29 * mary_hours >= 57, "c9")
model.addConstr(13 * george_hours + 4 * peggy_hours + 6 * laura_hours + 29 * mary_hours >= 57, "c10")
model.addConstr(4 * george_hours + 7 * mary_hours >= 118, "c11")
model.addConstr(4 * george_hours + 7 * laura_hours >= 50, "c12")
model.addConstr(16 * peggy_hours + 7 * laura_hours >= 67, "c13")
model.addConstr(4 * george_hours + 7 * laura_hours + 7 * mary_hours >= 64, "c14")
model.addConstr(4 * george_hours + 16 * peggy_hours + 7 * laura_hours + 7 * mary_hours >= 64, "c15")
model.addConstr(4 * george_hours - 7 * peggy_hours >= 0, "c16")
model.addConstr(13 * george_hours + 6 * laura_hours <= 156, "c17")
model.addConstr(13 * george_hours + 4 * peggy_hours + 6 * laura_hours <= 270, "c18")
model.addConstr(4 * george_hours + 16 * peggy_hours <= 391, "c19")
model.addConstr(16 * peggy_hours + 7 * mary_hours <= 317, "c20")
model.addConstr(16 * peggy_hours + 7 * laura_hours <= 357, "c21")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("George Hours:", george_hours.x)
    print("Peggy Hours:", peggy_hours.x)
    print("Laura Hours:", laura_hours.x)
    print("Mary Hours:", mary_hours.x)
    print("Objective Value:", model.objVal)
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization ended with status:", model.status)
