
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
G = m.addVar(lb=0, name="hours_worked_by_George")
P = m.addVar(lb=0, name="hours_worked_by_Peggy")
L = m.addVar(lb=0, name="hours_worked_by_Laura")
M = m.addVar(lb=0, name="hours_worked_by_Mary")

# Objective function
m.setObjective(5*G + P + 9*L + 4*M, gp.GRB.MINIMIZE)

# Organization score constraints
m.addConstr(13*G + 4*P + 6*L + 29*M <= 329, name="org_score_r0")
m.addConstr(4*G + 16*P + 7*L + 7*M <= 509, name="org_score_r1")

# Specific organization score constraints
m.addConstr(4*P + 29*M >= 76, name="org_score_P_M")
m.addConstr(13*G + 4*P >= 45, name="org_score_G_P")
m.addConstr(13*G + 6*L >= 82, name="org_score_G_L")
m.addConstr(13*G + 29*M >= 60, name="org_score_G_M")
m.addConstr(6*L + 29*M >= 59, name="org_score_L_M")
m.addConstr(4*P + 6*L + 29*M >= 58, name="org_score_P_L_M")
m.addConstr(13*G + 6*L + 29*M >= 58, name="org_score_G_L_M")
m.addConstr(4*P + 6*L + 29*M >= 57, name="org_score_P_L_M_2")
m.addConstr(13*G + 4*P + 6*L + 29*M >= 57, name="org_score_all")

# Specific paperwork competence rating constraints
m.addConstr(4*G + 7*M >= 118, name="paperwork_G_M")
m.addConstr(4*G + 7*L >= 50, name="paperwork_G_L")
m.addConstr(16*P + 7*L >= 67, name="paperwork_P_L")
m.addConstr(4*G + 7*L + 7*M >= 64, name="paperwork_G_L_M")
m.addConstr(4*G + 16*P + 7*L + 7*M >= 64, name="paperwork_all")

# Other constraints
m.addConstr(4*G - 7*P >= 0, name="other_G_P")
m.addConstr(13*G + 6*L <= 156, name="other_G_L")
m.addConstr(13*G + 4*P + 6*L <= 270, name="other_G_P_L")
m.addConstr(4*G + 16*P <= 391, name="other_G_P_2")
m.addConstr(16*P + 7*M <= 317, name="other_P_M")
m.addConstr(16*P + 7*L <= 357, name="other_P_L")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Peggy: ", P.varValue)
    print("Hours worked by Laura: ", L.varValue)
    print("Hours worked by Mary: ", M.varValue)
else:
    print("The model is infeasible")
