
from gurobipy import *

# Create a model
model = Model("Optimization_Problem")

# Define decision variables
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_zinc")
fat = model.addVar(lb=0, vtype=GRB.INTEGER, name="grams_of_fat")
iron = model.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_iron")
vitaminK = model.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_K")
vitaminB5 = model.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B5")

# Objective function
model.setObjective(6*zinc + 1*fat + 5*iron + 8*vitaminK + 8*vitaminB5, GRB.MINIMIZE)

# Constraints (only a few examples shown due to the large number)
# Immune support index constraints
model.addConstr(0.67*zinc + 0.33*iron >= 95, "immune_support_1")
model.addConstr(0.67*zinc + 0.33*vitaminK <= 133, "immune_support_2")

# Cardiovascular support index constraints
model.addConstr(0.5*fait + 0.5*iron <= 329, "cardiovascular_support_1")
model.addConstr(0.4*zinc + 0.3*vitaminK + 0.3*vitaminB5 <= 240, "cardiovascular_support_2")

# Cognitive support index constraints
model.addConstr(0.6*fait + 0.4*iron <= 140, "cognitive_support_1")
model.addConstr(0.7*zinc + 0.15*vitaminK + 0.15*vitaminB5 <= 295, "cognitive_support_2")

# Energy support index constraints
model.addConstr(0.3*fait + 0.7*vitaminB5 >= 68, "energy_support_1")
model.addConstr(0.4*zinc + 0.6*iron <= 166, "energy_support_2")

# Muscle growth index constraints
model.addConstr(0.6*iron + 0.4*vitaminK >= 40, "muscle_growth_1")
model.addConstr(0.5*zinc + 0.5*vitaminB5 <= 110, "muscle_growth_2")

# Additional constraints (only one example)
model.addConstr(-6*zinc + vitaminK >= 0, "additional_constraint")

# Optimize model
model.optimize()

# Print solution
for v in model.getVars():
    print("%s %f" % (v.varName, v.x))
