
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cheeseburgers = m.addVar(name="cheeseburgers", lb=0)
cornichons = m.addVar(name="cornichons", lb=0)
milkshakes = m.addVar(name="milkshakes", lb=0)
ramen = m.addVar(name="ramen", lb=0)
pies = m.addVar(name="pies", lb=0)

# Set objective function
m.setObjective(5 * cheeseburgers + 6 * cornichons + 8 * milkshakes + 7 * ramen + 8 * pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.44 * cheeseburgers + 2.96 * cornichons >= 16, "c1")
m.addConstr(2.96 * cornichons + 1.88 * ramen + 6.79 * pies >= 31, "c2")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes + 1.88 * ramen >= 31, "c3")
m.addConstr(0.23 * milkshakes + 1.88 * ramen + 6.79 * pies >= 31, "c4")
m.addConstr(3.44 * cheeseburgers + 1.88 * ramen + 6.79 * pies >= 31, "c5")
m.addConstr(2.96 * cornichons + 1.88 * ramen + 6.79 * pies >= 23, "c6")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes + 1.88 * ramen >= 23, "c7")
m.addConstr(0.23 * milkshakes + 1.88 * ramen + 6.79 * pies >= 23, "c8")
m.addConstr(3.44 * cheeseburgers + 1.88 * ramen + 6.79 * pies >= 23, "c9")
m.addConstr(2.96 * cornichons + 1.88 * ramen + 6.79 * pies >= 39, "c10")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes + 1.88 * ramen >= 39, "c11")
m.addConstr(0.23 * milkshakes + 1.88 * ramen + 6.79 * pies >= 39, "c12")
m.addConstr(3.44 * cheeseburgers + 1.88 * ramen + 6.79 * pies >= 39, "c13")
m.addConstr(2.96 * cornichons + 1.88 * ramen + 6.79 * pies >= 36, "c14")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes + 1.88 * ramen >= 36, "c15")
m.addConstr(0.23 * milkshakes + 1.88 * ramen + 6.79 * pies >= 36, "c16")
m.addConstr(3.44 * cheeseburgers + 1.88 * ramen + 6.79 * pies >= 36, "c17")
m.addConstr(3.44 * cheeseburgers + 2.96 * cornichons + 0.23 * milkshakes + 1.88 * ramen + 6.79 * pies >= 36, "c18")

m.addConstr(1.59 * cornichons + 5.85 * milkshakes >= 15, "c19")
m.addConstr(1.59 * cornichons + 4.71 * pies >= 19, "c20")
m.addConstr(0.38 * cheeseburgers + 3.98 * ramen >= 35, "c21")
m.addConstr(0.38 * cheeseburgers + 4.71 * pies >= 33, "c22")
m.addConstr(3.98 * ramen + 4.71 * pies >= 15, "c23")
m.addConstr(5.85 * milkshakes + 4.71 * pies >= 43, "c24")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons >= 40, "c25")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 3.98 * ramen >= 46, "c26")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 4.71 * pies >= 46, "c27")
m.addConstr(1.59 * cornichons + 3.98 * ramen + 4.71 * pies >= 46, "c28")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 3.98 * ramen >= 46, "c29")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 3.98 * ramen >= 31, "c30")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 4.71 * pies >= 31, "c31")
m.addConstr(1.59 * cornichons + 3.98 * ramen + 4.71 * pies >= 31, "c32")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 3.98 * ramen >= 31, "c33")

m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 3.98 * ramen >= 28, "c34")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 4.71 * pies >= 28, "c35")
m.addConstr(1.59 * cornichons + 3.98 * ramen + 4.71 * pies >= 28, "c36")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 3.98 * ramen >= 28, "c37")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 3.98 * ramen >= 44, "c38")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 4.71 * pies >= 44, "c39")
m.addConstr(1.59 * cornichons + 3.98 * ramen + 4.71 * pies >= 44, "c40")
m.addConstr(1.59 * cornichons + 5.85 * milkshakes + 3.98 * ramen >= 44, "c41")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 5.85 * milkshakes + 3.98 * ramen + 4.71 * pies >= 44, "c42")


m.addConstr(-8 * ramen + 5 * pies >= 0, "c43")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes <= 122, "c44")
m.addConstr(0.23 * milkshakes + 1.88 * ramen <= 64, "c45")
m.addConstr(3.44 * cheeseburgers + 6.79 * pies <= 116, "c46")
m.addConstr(2.96 * cornichons + 6.79 * pies <= 139, "c47")
m.addConstr(2.96 * cornichons + 0.23 * milkshakes + 6.79 * pies <= 181, "c48")

m.addConstr(5.85 * milkshakes + 3.98 * ramen <= 209, "c49")
m.addConstr(0.38 * cheeseburgers + 5.85 * milkshakes <= 204, "c50")
m.addConstr(1.59 * cornichons + 3.98 * ramen <= 109, "c51")
m.addConstr(0.38 * cheeseburgers + 3.98 * ramen <= 152, "c52")
m.addConstr(5.85 * milkshakes + 4.71 * pies <= 195, "c53")
m.addConstr(0.38 * cheeseburgers + 4.71 * pies <= 151, "c54")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 5.85 * milkshakes <= 205, "c55")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 3.98 * ramen <= 130, "c56")
m.addConstr(0.38 * cheeseburgers + 1.59 * cornichons + 4.71 * pies <= 162, "c57")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

