
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Hours")

# Create variables
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")

# Set objective function
m.setObjective(7 * peggy + 6 * bobby + 4 * bill + 4 * george, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.56 * peggy + 0.41 * bill <= 137, "c1")
m.addConstr(0.61 * bobby + 1.81 * george <= 121, "c2")
m.addConstr(0.56 * peggy + 0.61 * bobby <= 163, "c3")
m.addConstr(0.41 * bill + 1.81 * george <= 181, "c4")
m.addConstr(0.56 * peggy + 0.61 * bobby + 0.41 * bill + 1.81 * george <= 181, "c5")
m.addConstr(0.29 * bobby + 0.09 * george <= 111, "c6")
m.addConstr(0.47 * peggy + 1.32 * bill <= 33, "c7")
m.addConstr(0.47 * peggy + 0.09 * george <= 82, "c8")
m.addConstr(1.32 * bill + 0.09 * george <= 78, "c9")
m.addConstr(0.47 * peggy + 0.29 * bobby + 1.32 * bill + 0.09 * george <= 78, "c10")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

