
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x1 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x2 = m.addVar(lb=0, name="hours_worked_by_Bill")
x3 = m.addVar(lb=0, name="hours_worked_by_George")

# Define the objective function
m.setObjective(7*x0 + 6*x1 + 4*x2 + 4*x3, GRB.MAXIMIZE)

# Add constraints based on the problem description
m.addConstr(0.56*x0 <= 222, name="Peggy_computer_rating")
m.addConstr(0.47*x0 <= 124, name="Peggy_quit_index")

m.addConstr(0.61*x1 <= 222, name="Bobby_computer_rating")
m.addConstr(0.29*x1 <= 124, name="Bobby_quit_index")

m.addConstr(0.41*x2 <= 222, name="Bill_computer_rating")
m.addConstr(1.32*x2 <= 124, name="Bill_quit_index")

m.addConstr(1.81*x3 <= 222, name="George_computer_rating")
m.addConstr(0.09*x3 <= 124, name="George_quit_index")

# Combined constraints
m.addConstr(0.56*x0 + 0.41*x2 <= 137, name="Peggy_Bill_computer_rating_combined")
m.addConstr(0.61*x1 + 1.81*x3 <= 121, name="Bobby_George_computer_rating_combined")
m.addConstr(0.56*x0 + 0.61*x1 <= 163, name="Peggy_Bobby_computer_rating_combined")
m.addConstr(0.41*x2 + 1.81*x3 <= 181, name="Bill_George_computer_rating_combined")
m.addConstr(0.56*x0 + 0.61*x1 + 0.41*x2 + 1.81*x3 <= 181, name="All_computer_rating_combined")

m.addConstr(0.29*x1 + 0.09*x3 <= 111, name="Bobby_George_quit_index_combined")
m.addConstr(0.47*x0 + 1.32*x2 <= 33, name="Peggy_Bill_quit_index_combined")
m.addConstr(0.47*x0 + 0.09*x3 <= 82, name="Peggy_George_quit_index_combined")
m.addConstr(1.32*x2 + 0.09*x3 <= 78, name="Bill_George_quit_index_combined")
m.addConstr(0.47*x0 + 0.29*x1 + 1.32*x2 + 0.09*x3 <= 78, name="All_quit_index_combined")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
