
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    peggy_hours = model.addVar(name="peggy_hours", lb=0)
    bobby_hours = model.addVar(name="bobby_hours", lb=0)
    bill_hours = model.addVar(name="bill_hours", lb=0)
    george_hours = model.addVar(name="george_hours", lb=0)

    # Objective function
    model.setObjective(7 * peggy_hours + 6 * bobby_hours + 4 * bill_hours + 4 * george_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual computer competence ratings (not actually constraints since they are fixed)
    # peggy_hours * 0.56 <= 0.56 (always true since lb=0 and coeff=0.56)
    # bobby_hours * 0.61 <= 0.61
    # bill_hours * 0.41 <= 0.41
    # george_hours * 1.81 <= 1.81

    # Individual likelihood to quit indices (not actually constraints since they are fixed)
    # peggy_hours * 0.47 <= 0.47
    # bobby_hours * 0.29 <= 0.29
    # bill_hours * 1.32 <= 1.32
    # george_hours * 0.09 <= 0.09

    # Combined computer competence ratings
    model.addConstr(0.56 * peggy_hours + 0.41 * bill_hours <= 137, name="peggy_bill_competence")
    model.addConstr(0.61 * bobby_hours + 1.81 * george_hours <= 121, name="bobby_george_competence")
    model.addConstr(0.56 * peggy_hours + 0.61 * bobby_hours <= 163, name="peggy_bobby_competence")
    model.addConstr(0.41 * bill_hours + 1.81 * george_hours <= 181, name="bill_george_competence")
    model.addConstr(0.56 * peggy_hours + 0.61 * bobby_hours + 0.41 * bill_hours + 1.81 * george_hours <= 222, name="total_competence")

    # Combined likelihood to quit indices
    model.addConstr(0.29 * bobby_hours + 0.09 * george_hours <= 111, name="bobby_george_quit")
    model.addConstr(0.47 * peggy_hours + 1.32 * bill_hours <= 33, name="peggy_bill_quit")
    model.addConstr(0.47 * peggy_hours + 0.09 * george_hours <= 82, name="peggy_george_quit")
    model.addConstr(1.32 * bill_hours + 0.09 * george_hours <= 78, name="bill_george_quit")
    model.addConstr(0.47 * peggy_hours + 0.29 * bobby_hours + 1.32 * bill_hours + 0.09 * george_hours <= 124, name="total_quit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Peggy hours: {peggy_hours.varValue}")
        print(f"Bobby hours: {bobby_hours.varValue}")
        print(f"Bill hours: {bill_hours.varValue}")
        print(f"George hours: {george_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
