
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
pasta = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")
oranges = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
tomatoes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tomatoes")
ravioli = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")

# Set objective function
model.setObjective(7 * pasta + 3 * oranges + 7 * tomatoes + 5 * ravioli, GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * pasta + 6 * tomatoes >= 14, "c1")
model.addConstr(18 * pasta + 18 * oranges >= 15, "c2")
model.addConstr(18 * pasta + 6 * tomatoes + 16 * ravioli >= 24, "c3")
model.addConstr(18 * oranges + 6 * tomatoes + 16 * ravioli >= 24, "c4")
model.addConstr(18 * pasta + 6 * tomatoes + 16 * ravioli >= 38, "c5")
model.addConstr(18 * oranges + 6 * tomatoes + 16 * ravioli >= 38, "c6")
model.addConstr(18 * pasta + 18 * oranges + 6 * tomatoes + 16 * ravioli >= 38, "c7")

model.addConstr(4 * pasta + 19 * ravioli >= 31, "c8")
model.addConstr(6 * tomatoes + 19 * ravioli >= 27, "c9")
model.addConstr(4 * pasta + 9 * oranges >= 31, "c10")
model.addConstr(9 * oranges + 6 * tomatoes >= 25, "c11")
model.addConstr(4 * pasta + 9 * oranges + 6 * tomatoes >= 32, "c12")
model.addConstr(4 * pasta + 6 * tomatoes + 19 * ravioli >= 32, "c13")
model.addConstr(4 * pasta + 9 * oranges + 6 * tomatoes >= 26, "c14")
model.addConstr(4 * pasta + 6 * tomatoes + 19 * ravioli >= 26, "c15")
model.addConstr(4 * pasta + 9 * oranges + 6 * tomatoes + 19 * ravioli >= 26, "c16")

model.addConstr(6 * oranges - 4 * tomatoes >= 0, "c17")

model.addConstr(18 * oranges + 16 * ravioli <= 149, "c18")
model.addConstr(18 * pasta + 18 * oranges <= 124, "c19")
model.addConstr(18 * oranges + 6 * tomatoes <= 139, "c20")
model.addConstr(6 * tomatoes + 16 * ravioli <= 72, "c21")
model.addConstr(18 * pasta + 18 * oranges + 6 * tomatoes <= 159, "c22")

model.addConstr(6 * tomatoes + 19 * ravioli <= 56, "c23")
model.addConstr(4 * pasta + 19 * ravioli <= 42, "c24")
model.addConstr(9 * oranges + 19 * ravioli <= 108, "c25")
model.addConstr(4 * pasta + 9 * oranges <= 122, "c26")
model.addConstr(4 * pasta + 6 * tomatoes + 19 * ravioli <= 113, "c27")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
