
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    bowls_of_pasta = model.addVar(name="bowls_of_pasta", lb=0)
    oranges = model.addVar(name="oranges", lb=0)
    tomatoes = model.addVar(name="tomatoes", lb=0)
    ravioli = model.addVar(name="ravioli", lb=0)

    # Objective function
    model.setObjective(7 * bowls_of_pasta + 3 * oranges + 7 * tomatoes + 5 * ravioli, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(18 * bowls_of_pasta + 6 * tomatoes >= 14, name="sourness_pasta_tomatoes")
    model.addConstr(18 * bowls_of_pasta + 18 * oranges >= 15, name="sourness_pasta_oranges")
    model.addConstr(18 * bowls_of_pasta + 6 * tomatoes + 16 * ravioli >= 24, name="sourness_pasta_tomatoes_ravioli")
    model.addConstr(18 * oranges + 6 * tomatoes + 16 * ravioli >= 24, name="sourness_oranges_tomatoes_ravioli")
    model.addConstr(18 * bowls_of_pasta + 6 * tomatoes + 16 * ravioli >= 38, name="sourness_pasta_tomatoes_ravioli_2")
    model.addConstr(18 * oranges + 6 * tomatoes + 16 * ravioli >= 38, name="sourness_oranges_tomatoes_ravioli_2")
    model.addConstr(18 * bowls_of_pasta + 18 * oranges + 6 * tomatoes + 16 * ravioli >= 38, name="sourness_all")

    model.addConstr(4 * bowls_of_pasta + 19 * ravioli >= 31, name="umami_pasta_ravioli")
    model.addConstr(6 * tomatoes + 19 * ravioli >= 27, name="umami_tomatoes_ravioli")
    model.addConstr(4 * bowls_of_pasta + 9 * oranges >= 31, name="umami_pasta_oranges")
    model.addConstr(9 * oranges + 6 * tomatoes >= 25, name="umami_oranges_tomatoes")
    model.addConstr(4 * bowls_of_pasta + 9 * oranges + 6 * tomatoes >= 32, name="umami_pasta_oranges_tomatoes")
    model.addConstr(4 * bowls_of_pasta + 6 * tomatoes + 19 * ravioli >= 32, name="umami_pasta_tomatoes_ravioli")
    model.addConstr(4 * bowls_of_pasta + 9 * oranges + 6 * tomatoes >= 26, name="umami_pasta_oranges_tomatoes_2")
    model.addConstr(4 * bowls_of_pasta + 6 * tomatoes + 19 * ravioli >= 26, name="umami_pasta_tomatoes_ravioli_2")
    model.addConstr(4 * bowls_of_pasta + 9 * oranges + 6 * tomatoes + 19 * ravioli >= 26, name="umami_all")

    model.addConstr(6 * oranges - 4 * tomatoes >= 0, name="linear_constraint")

    model.addConstr(18 * oranges + 16 * ravioli <= 149, name="upper_bound_oranges_ravioli")
    model.addConstr(18 * bowls_of_pasta + 18 * oranges <= 124, name="upper_bound_pasta_oranges")
    model.addConstr(18 * oranges + 6 * tomatoes <= 139, name="upper_bound_oranges_tomatoes")
    model.addConstr(6 * tomatoes + 16 * ravioli <= 72, name="upper_bound_tomatoes_ravioli")
    model.addConstr(18 * bowls_of_pasta + 18 * oranges + 6 * tomatoes <= 159, name="upper_bound_pasta_oranges_tomatoes")
    model.addConstr(6 * tomatoes + 19 * ravioli <= 56, name="upper_bound_tomatoes_ravioli_2")
    model.addConstr(4 * bowls_of_pasta + 19 * ravioli <= 42, name="upper_bound_pasta_ravioli")
    model.addConstr(9 * oranges + 19 * ravioli <= 108, name="upper_bound_oranges_ravioli_2")
    model.addConstr(4 * bowls_of_pasta + 9 * oranges <= 122, name="upper_bound_pasta_oranges_2")
    model.addConstr(4 * bowls_of_pasta + 6 * tomatoes + 19 * ravioli <= 113, name="upper_bound_pasta_tomatoes_ravioli")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Bowls of pasta: ", bowls_of_pasta.varValue)
        print("Oranges: ", oranges.varValue)
        print("Tomatoes: ", tomatoes.varValue)
        print("Ravioli: ", ravioli.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
