
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="carbohydrates")
iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")

# Set objective function
m.setObjective(8 * vitamin_b2 + 3 * fat + 1 * carbohydrates + 4 * iron, gp.GRB.MAXIMIZE)

# Add constraints based on resource indices
immune_support_index = {
    'vitamin_b2': 1,
    'fat': 9,
    'carbohydrates': 4,
    'iron': 11
}

cognitive_performance_index = {
    'vitamin_b2': 8,
    'fat': 1,
    'carbohydrates': 6,
    'iron': 11
}

# Resource constraints (upper bounds are handled separately)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['fat'] * fat >= 49)
m.addConstr(immune_support_index['fat'] * fat + immune_support_index['carbohydrates'] * carbohydrates >= 61)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['carbohydrates'] * carbohydrates >= 21)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['iron'] * iron >= 32)

m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat >= 57)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['carbohydrates'] * carbohydrates + cognitive_performance_index['iron'] * iron >= 51)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['carbohydrates'] * carbohydrates >= 51)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['iron'] * iron >= 51)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['carbohydrates'] * carbohydrates + cognitive_performance_index['iron'] * iron >= 36)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['carbohydrates'] * carbohydrates >= 36)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['iron'] * iron >= 36)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['carbohydrates'] * carbohydrates + cognitive_performance_index['iron'] * iron >= 40)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['carbohydrates'] * carbohydrates >= 40)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['iron'] * iron >= 40)


# Resource upper bound constraints (from the provided resource dictionary)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['fat'] * fat + immune_support_index['carbohydrates'] * carbohydrates <= 94)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['carbohydrates'] * carbohydrates + immune_support_index['iron'] * iron <= 174)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['fat'] * fat + immune_support_index['iron'] * iron <= 197)
m.addConstr(immune_support_index['vitamin_b2'] * vitamin_b2 + immune_support_index['fat'] * fat + immune_support_index['carbohydrates'] * carbohydrates + immune_support_index['iron'] * iron <= 197)
m.addConstr(immune_support_index['carbohydrates'] * carbohydrates + immune_support_index['iron'] * iron <= 237)


m.addConstr(cognitive_performance_index['fat'] * fat + cognitive_performance_index['carbohydrates'] * carbohydrates <= 174)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['iron'] * iron <= 201)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat <= 205)
m.addConstr(cognitive_performance_index['carbohydrates'] * carbohydrates + cognitive_performance_index['iron'] * iron <= 114)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['iron'] * iron <= 243)
m.addConstr(cognitive_performance_index['vitamin_b2'] * vitamin_b2 + cognitive_performance_index['fat'] * fat + cognitive_performance_index['carbohydrates'] * carbohydrates + cognitive_performance_index['iron'] * iron <= 243)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_b2:', vitamin_b2.x)
    print('fat:', fat.x)
    print('carbohydrates:', carbohydrates.x)
    print('iron:', iron.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
