
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B2")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of fat")
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="grams of carbohydrates")
    x3 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="milligrams of iron")

    # Objective function
    model.setObjective(8*x0 + 3*x1 + x2 + 4*x3, gurobi.GRB.MAXIMIZE)

    # Immune Support Index Constraints
    model.addConstr(x0 <= 246, name="immune_support_index_r0")
    model.addConstr(x0 + 9*x1 >= 49, name="immune_support_index_constraint_1")
    model.addConstr(9*x1 + 4*x2 >= 61, name="immune_support_index_constraint_2")
    model.addConstr(x0 + 4*x2 >= 21, name="immune_support_index_constraint_3")
    model.addConstr(x0 + 11*x3 >= 32, name="immune_support_index_constraint_4")
    model.addConstr(x0 + 9*x1 + 4*x2 + 11*x3 <= 197, name="immune_support_index_constraint_5")
    model.addConstr(x0 + 9*x1 + 4*x2 <= 94, name="immune_support_index_constraint_6")
    model.addConstr(x0 + 4*x2 + 11*x3 <= 174, name="immune_support_index_constraint_7")
    model.addConstr(4*x2 + 11*x3 <= 237, name="immune_support_index_constraint_8")

    # Cognitive Performance Index Constraints
    model.addConstr(8*x0 + x1 >= 57, name="cognitive_performance_index_constraint_1")
    model.addConstr(8*x0 + 6*x2 + 11*x3 >= 51, name="cognitive_performance_index_constraint_2")
    model.addConstr(8*x0 + x1 + 6*x2 >= 51, name="cognitive_performance_index_constraint_3")
    model.addConstr(8*x0 + x1 + 11*x3 >= 51, name="cognitive_performance_index_constraint_4")
    model.addConstr(8*x0 + 6*x2 + 11*x3 >= 40, name="cognitive_performance_index_constraint_5")
    model.addConstr(8*x0 + x1 + 6*x2 >= 36, name="cognitive_performance_index_constraint_6")
    model.addConstr(8*x0 + x1 + 11*x3 >= 36, name="cognitive_performance_index_constraint_7")
    model.addConstr(8*x0 + 6*x2 + 11*x3 >= 40, name="cognitive_performance_index_constraint_8")
    model.addConstr(x1 + 6*x2 <= 174, name="cognitive_performance_index_constraint_9")
    model.addConstr(8*x0 + 11*x3 <= 201, name="cognitive_performance_index_constraint_10")
    model.addConstr(8*x0 + x1 <= 205, name="cognitive_performance_index_constraint_11")
    model.addConstr(6*x2 + 11*x3 <= 114, name="cognitive_performance_index_constraint_12")
    model.addConstr(8*x0 + x1 + 11*x3 <= 243, name="cognitive_performance_index_constraint_13")
    model.addConstr(8*x0 + x1 + 6*x2 + 11*x3 <= 243, name="cognitive_performance_index_constraint_14")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

optimize()
