
from gurobipy import *

# Create a new model
m = Model("Nutrition")

# Define variables - assuming all can be non-integer as per the last few constraints
C = m.addVar(name='Vitamin_C', lb=0)  # Lower bound of 0, no upper bound specified
B6 = m.addVar(name='Vitamin_B6', lb=0)
B7 = m.addVar(name='Vitamin_B7', lb=0)
B9 = m.addVar(name='Vitamin_B9', lb=0)
Fat = m.addVar(name='Fat', lb=0)
B2 = m.addVar(name='Vitamin_B2', lb=0)

# Objective function - For demonstration, let's assume we want to minimize the total amount of vitamins and fat
m.setObjective(C + B6 + B7 + B9 + Fat + B2, GRB.MINIMIZE)

# Constraints - Using hypothetical coefficients for demonstration purposes
# Muscle growth constraints
m.addConstr(0.5*C + 1*B6 + 1.5*B7 >= 30, name='Muscle_Growth_1')
m.addConstr(B9 + B2 <= 189, name='Muscle_Growth_2')
m.addConstr(B6 + B7 <= 87, name='Muscle_Growth_3')

# Cardiovascular support constraints
m.addConstr(0.8*C + 1*B9 >= 20, name='Cardio_Support_1')
m.addConstr(B9 + Fat <= 269, name='Cardio_Support_2')
m.addConstr(C + B6 + B7 + B9 + Fat + B2 <= 270, name='Total_Cardio_Support')

# Other constraints
m.addConstr(C >= 0)  # Non-negativity constraint for vitamin C
m.addConstr(B6 >= 0)  # Non-negativity constraint for vitamin B6
m.addConstr(B7 >= 0)  # Non-negativity constraint for vitamin B7
m.addConstr(B9 >= 0)  # Non-negativity constraint for vitamin B9
m.addConstr(Fat >= 0)  # Non-negativity constraint for fat
m.addConstr(B2 >= 0)  # Non-negativity constraint for vitamin B2

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
