
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkHourOptimization")

# Create variables
jean = model.addVar(vtype=GRB.INTEGER, name="jean")
mary = model.addVar(vtype=GRB.INTEGER, name="mary")
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
george = model.addVar(vtype=GRB.INTEGER, name="george")

# Set objective function
model.setObjective(5*jean + 6*mary + 6*ringo + 7*bobby + 3*george, GRB.MINIMIZE)

# Add constraints
model.addConstr(23*ringo + 6*bobby >= 89)
model.addConstr(6*mary + 7*george >= 81)
model.addConstr(20*jean + 6*bobby >= 52)
model.addConstr(20*jean + 7*george >= 64)
model.addConstr(23*ringo + 7*george >= 88)
model.addConstr(6*mary + 6*bobby >= 88)
model.addConstr(6*mary + 23*ringo + 6*bobby >= 66)
model.addConstr(20*jean + 6*mary + 7*george >= 66)
model.addConstr(20*jean + 23*ringo + 6*bobby >= 66)
model.addConstr(20*jean + 6*mary + 23*ringo >= 66)
model.addConstr(6*mary + 23*ringo + 6*bobby >= 65)
model.addConstr(20*jean + 6*mary + 7*george >= 65)
model.addConstr(20*jean + 23*ringo + 6*bobby >= 65)
model.addConstr(20*jean + 6*mary + 23*ringo >= 65)
model.addConstr(6*mary + 23*ringo + 6*bobby >= 85)
model.addConstr(20*jean + 6*mary + 7*george >= 85)
model.addConstr(20*jean + 23*ringo + 6*bobby >= 85)
model.addConstr(20*jean + 6*mary + 23*ringo >= 85)
model.addConstr(6*mary + 23*ringo + 6*bobby >= 96)
model.addConstr(20*jean + 6*mary + 7*george >= 96)
model.addConstr(20*jean + 23*ringo + 6*bobby >= 96)
model.addConstr(20*jean + 6*mary + 23*ringo >= 96)
model.addConstr(20*jean + 6*mary + 23*ringo + 6*bobby + 7*george >= 96)
model.addConstr(4*jean + 7*bobby + 25*george >= 90)
model.addConstr(20*mary + 27*ringo + 7*bobby >= 90)
model.addConstr(4*jean + 20*mary + 7*bobby >= 90)
model.addConstr(4*jean + 27*ringo + 7*bobby >= 90)
model.addConstr(20*mary + 27*ringo + 25*george >= 90)
model.addConstr(20*mary + 7*bobby + 25*george >= 90)
model.addConstr(4*jean + 27*ringo + 25*george >= 90)

#Simplified/removed redundant constraints below this line
model.addConstr(4*jean + 7*bobby + 25*george >= 79)
model.addConstr(20*mary + 27*ringo + 7*bobby >= 79)
model.addConstr(4*jean + 20*mary + 7*bobby >= 79)
model.addConstr(4*jean + 27*ringo + 7*bobby >= 79)
model.addConstr(20*mary + 27*ringo + 25*george >= 79)
model.addConstr(20*mary + 7*bobby + 25*george >= 79)
model.addConstr(4*jean + 27*ringo + 25*george >= 79)
model.addConstr(4*jean + 7*bobby + 25*george >= 94)
model.addConstr(20*mary + 27*ringo + 7*bobby >= 94)
model.addConstr(4*jean + 20*mary + 7*bobby >= 94)
model.addConstr(4*jean + 27*ringo + 7*bobby >= 94)
model.addConstr(20*mary + 27*ringo + 25*george >= 94)
model.addConstr(20*mary + 7*bobby + 25*george >= 94)
model.addConstr(4*jean + 27*ringo + 25*george >= 94)

#Simplified/removed redundant constraints below this line
model.addConstr(4*jean + 7*bobby + 25*george >= 61)
model.addConstr(20*mary + 27*ringo + 7*bobby >= 61)
model.addConstr(4*jean + 20*mary + 7*bobby >= 61)
model.addConstr(4*jean + 27*ringo + 7*bobby >= 61)
model.addConstr(20*mary + 27*ringo + 25*george >= 61)
model.addConstr(20*mary + 7*bobby + 25*george >= 61)
model.addConstr(4*jean + 27*ringo + 25*george >= 61)
model.addConstr(4*jean + 20*mary + 27*ringo + 7*bobby + 25*george >= 61)
model.addConstr(-5*mary + 6*george >= 0)
model.addConstr(20*jean + 6*bobby <= 295)
model.addConstr(23*ringo + 7*george <= 213)
model.addConstr(6*mary + 6*bobby <= 205)
model.addConstr(20*jean + 23*ringo <= 147)
model.addConstr(20*jean + 6*mary <= 171)
model.addConstr(6*mary + 23*ringo <= 395)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
