
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
steaks = model.addVar(lb=0, name="steaks", vtype=gurobi.GRB.CONTINUOUS)
bowls_of_instant_ramen = model.addVar(lb=0, name="bowls_of_instant_ramen", vtype=gurobi.GRB.CONTINUOUS)
kiwis = model.addVar(lb=0, name="kiwis", vtype=gurobi.GRB.CONTINUOUS)
cornichons = model.addVar(lb=0, name="cornichons", vtype=gurobi.GRB.CONTINUOUS)
cherry_pies = model.addVar(lb=0, name="cherry_pies", vtype=gurobi.GRB.CONTINUOUS)
protein_bars = model.addVar(lb=0, name="protein_bars", vtype=gurobi.GRB.CONTINUOUS)
lemons = model.addVar(lb=0, name="lemons", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(1 * steaks + 9 * bowls_of_instant_ramen + 6 * kiwis + 3 * cornichons + 6 * cherry_pies + 8 * protein_bars + 7 * lemons, gurobi.GRB.MAXIMIZE)

# Define the constraints
# Resource constraints
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 17 * kiwis + 13 * cornichons + 9 * cherry_pies + 6 * protein_bars + 16 * lemons <= 679, 'r0')
model.addConstr(12 * steaks + 14 * bowls_of_instant_ramen + 26 * kiwis + 11 * cornichons + 5 * cherry_pies + 5 * protein_bars + 23 * lemons <= 451, 'r1')
model.addConstr(6 * steaks + 29 * bowls_of_instant_ramen + 28 * kiwis + 8 * cornichons + 25 * cherry_pies + 27 * protein_bars + 15 * lemons <= 414, 'r2')

# Sourness index constraints
model.addConstr(17 * kiwis + 6 * protein_bars >= 58)
model.addConstr(23 * bowls_of_instant_ramen + 16 * lemons >= 97)
model.addConstr(23 * bowls_of_instant_ramen + 9 * cherry_pies >= 54)
model.addConstr(23 * bowls_of_instant_ramen + 17 * kiwis >= 73)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 9 * cherry_pies >= 65)
model.addConstr(13 * cornichons + 9 * cherry_pies + 6 * protein_bars >= 65)
model.addConstr(13 * cornichons + 9 * cherry_pies + 16 * lemons >= 65)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 9 * cherry_pies >= 65)
model.addConstr(13 * cornichons + 6 * protein_bars + 16 * lemons >= 65)
model.addConstr(steaks + 17 * kiwis + 6 * protein_bars >= 65)
model.addConstr(23 * bowls_of_instant_ramen + 6 * protein_bars + 16 * lemons >= 65)
model.addConstr(steaks + 13 * cornichons + 6 * protein_bars >= 65)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 6 * protein_bars >= 65)
model.addConstr(steaks + 17 * kiwis + 9 * cherry_pies >= 65)
model.addConstr(steaks + 17 * kiwis + 16 * lemons >= 65)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 16 * lemons >= 65)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 9 * cherry_pies >= 88)
model.addConstr(13 * cornichons + 9 * cherry_pies + 6 * protein_bars >= 88)
model.addConstr(13 * cornichons + 9 * cherry_pies + 16 * lemons >= 88)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 9 * cherry_pies >= 88)
model.addConstr(13 * cornichons + 6 * protein_bars + 16 * lemons >= 88)
model.addConstr(steaks + 17 * kiwis + 6 * protein_bars >= 88)
model.addConstr(23 * bowls_of_instant_ramen + 6 * protein_bars + 16 * lemons >= 88)
model.addConstr(steaks + 13 * cornichons + 6 * protein_bars >= 88)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 6 * protein_bars >= 88)
model.addConstr(steaks + 17 * kiwis + 9 * cherry_pies >= 88)
model.addConstr(steaks + 17 * kiwis + 16 * lemons >= 88)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 16 * lemons >= 88)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 9 * cherry_pies >= 90)
model.addConstr(13 * cornichons + 9 * cherry_pies + 6 * protein_bars >= 90)
model.addConstr(13 * cornichons + 9 * cherry_pies + 16 * lemons >= 90)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 9 * cherry_pies >= 90)
model.addConstr(13 * cornichons + 6 * protein_bars + 16 * lemons >= 90)
model.addConstr(steaks + 17 * kiwis + 6 * protein_bars >= 90)
model.addConstr(23 * bowls_of_instant_ramen + 6 * protein_bars + 16 * lemons >= 90)
model.addConstr(steaks + 13 * cornichons + 6 * protein_bars >= 90)
model.addConstr(23 * bowls_of_instant_ramen + 13 * cornichons + 6 * protein_bars >= 90)
model.addConstr(steaks + 17 * kiwis + 9 * cherry_pies >= 90)
model.addConstr(steaks + 17 * kiwis + 16 * lemons >= 90)
model.addConstr(steaks + 23 * bowls_of_instant_ramen + 16 * lemons >= 90)

# Fiber constraints
model.addConstr(12 * steaks + 5 * cherry_pies >= 60)
model.addConstr(14 * bowls_of_instant_ramen + 5 * cherry_pies >= 54)
model.addConstr(11 * cornichons + 23 * lemons >= 44)
model.addConstr(12 * steaks + 26 * kiwis + 5 * protein_bars >= 61)
model.addConstr(14 * bowls_of_instant_ramen + 26 * kiwis + 11 * cornichons >= 61)
model.addConstr(12 * steaks + 26 * kiwis + 5 * cherry_pies >= 61)
model.addConstr(14 * bowls_of_instant_ramen + 5 * cherry_pies + 23 * lemons >= 61)
model.addConstr(12 * steaks + 26 * kiwis + 23 * lemons >= 61)
model.addConstr(14 * bowls_of_instant_ramen + 11 * cornichons + 23 * lemons >= 61)
model.addConstr(11 * cornichons + 5 * protein_bars + 23 * lemons >= 61)
model.addConstr(14 * bowls_of_instant_ramen + 11 * cornichons + 5 * cherry_pies >= 61)

# Umami index constraints
model.addConstr(28 * kiwis + 15 * lemons >= 36)
model.addConstr(29 * bowls_of_instant_ramen + 28 * kiwis + 27 * protein_bars >= 36)
model.addConstr(6 * steaks + 27 * protein_bars + 15 * lemons >= 36)

# Bounds
model.addConstr(steaks + 23 * bowls_of_instant_ramen <= 179)
model.addConstr(steaks + 12 * cherry_pies <= 578)
model.addConstr(14 * bowls_of_instant_ramen + 5 * cherry_pies <= 203)

# Optimize
model.optimize()

# Print the results
print("Objective: ", model.objVal)
print("Steaks: ", steaks.varValue)
print("Bowls of instant ramen: ", bowls_of_instant_ramen.varValue)
print("Kiwis: ", kiwis.varValue)
print("Cornichons: ", cornichons.varValue)
print("Cherry pies: ", cherry_pies.varValue)
print("Protein bars: ", protein_bars.varValue)
print("Lemons: ", lemons.varValue)
