
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cereal = m.addVar(lb=0, name="cereal")
salad = m.addVar(lb=0, name="salad")
bananas = m.addVar(lb=0, name="bananas")
sashimi = m.addVar(lb=0, name="sashimi")

# Set objective function
m.setObjective(8.23 * cereal + 6.31 * salad + 5.0 * bananas + 1.13 * sashimi, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * cereal + 8 * salad + 7 * bananas >= 23, "fiber_constr1")
m.addConstr(3 * cereal + 8 * salad + 7 * bananas + 15 * sashimi >= 23, "fiber_constr2")
m.addConstr(3 * cereal + 8 * salad + 7 * bananas >= 21, "fiber_constr3")
m.addConstr(3 * cereal + 8 * salad + 7 * bananas + 15 * sashimi >= 21, "fiber_constr4")

m.addConstr(2 * salad + 17 * sashimi >= 22, "health_constr1")
m.addConstr(12 * cereal + 17 * sashimi >= 17, "health_constr2")
m.addConstr(12 * cereal + 10 * bananas >= 34, "health_constr3")
m.addConstr(12 * cereal + 2 * salad >= 14, "health_constr4")
m.addConstr(12 * cereal + 2 * salad + 10 * bananas >= 24, "health_constr5")
m.addConstr(12 * cereal + 2 * salad + 17 * sashimi >= 24, "health_constr6")
m.addConstr(2 * salad + 10 * bananas + 17 * sashimi >= 24, "health_constr7")
m.addConstr(12 * cereal + 2 * salad + 10 * bananas >= 17, "health_constr8")
m.addConstr(12 * cereal + 2 * salad + 17 * sashimi >= 17, "health_constr9")
m.addConstr(2 * salad + 10 * bananas + 17 * sashimi >= 17, "health_constr10")
m.addConstr(12 * cereal + 2 * salad + 10 * bananas >= 29, "health_constr11")
m.addConstr(12 * cereal + 2 * salad + 17 * sashimi >= 29, "health_constr12")
m.addConstr(2 * salad + 10 * bananas + 17 * sashimi >= 29, "health_constr13")


m.addConstr(-2 * cereal + 10 * sashimi >= 0, "constr14")
m.addConstr(8 * salad + 7 * bananas <= 121, "fiber_constr5")
m.addConstr(3 * cereal + 7 * bananas <= 122, "fiber_constr6")
m.addConstr(3 * cereal + 8 * salad + 7 * bananas + 15 * sashimi <= 122, "fiber_constr7")

m.addConstr(12 * cereal + 2 * salad <= 121, "health_constr14")
m.addConstr(12 * cereal + 17 * sashimi <= 61, "health_constr15")
m.addConstr(2 * salad + 10 * bananas <= 138, "health_constr16")
m.addConstr(12 * cereal + 2 * salad + 17 * sashimi <= 101, "health_constr17")
m.addConstr(12 * cereal + 2 * salad + 10 * bananas + 17 * sashimi <= 101, "health_constr18")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

