
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="bowls of cereal")
    x1 = model.addVar(lb=0, name="bagged salads")
    x2 = model.addVar(lb=0, name="bananas")
    x3 = model.addVar(lb=0, name="sashimi")

    # Define the objective function
    model.setObjective(8.23*x0 + 6.31*x1 + 5.0*x2 + 1.13*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 8*x1 + 7*x2 >= 23, name="fiber_from_cereal_salads_bananas")
    model.addConstr(3*x0 + 8*x1 + 15*x3 >= 23, name="fiber_from_cereal_salads_sashimi")
    model.addConstr(3*x0 + 8*x1 + 7*x2 >= 21, name="fiber_from_cereal_salads_bananas_2")
    model.addConstr(3*x0 + 8*x1 + 15*x3 >= 21, name="fiber_from_cereal_salads_sashimi_2")
    model.addConstr(2*x1 + 17*x3 >= 22, name="healthiness_from_salads_sashimi")
    model.addConstr(12*x0 + 17*x3 >= 17, name="healthiness_from_cereal_sashimi")
    model.addConstr(12*x0 + 10*x2 >= 34, name="healthiness_from_cereal_bananas")
    model.addConstr(12*x0 + 2*x1 >= 14, name="healthiness_from_cereal_salads")
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 24, name="healthiness_from_cereal_salads_bananas")
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 24, name="healthiness_from_cereal_salads_sashimi")
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 24, name="healthiness_from_salads_bananas_sashimi")
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 17, name="healthiness_from_cereal_salads_bananas_2")
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 17, name="healthiness_from_cereal_salads_sashimi_2")
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 17, name="healthiness_from_salads_bananas_sashimi_2")
    model.addConstr(12*x0 + 2*x1 + 10*x2 >= 29, name="healthiness_from_cereal_salads_bananas_3")
    model.addConstr(12*x0 + 2*x1 + 17*x3 >= 29, name="healthiness_from_cereal_salads_sashimi_3")
    model.addConstr(2*x1 + 10*x2 + 17*x3 >= 29, name="healthiness_from_salads_bananas_sashimi_3")
    model.addConstr(-2*x0 + 10*x3 >= 0, name="constraint_on_cereal_sashimi")
    model.addConstr(8*x1 + 7*x2 <= 121, name="fiber_from_salads_bananas")
    model.addConstr(3*x0 + 7*x2 <= 122, name="fiber_from_cereal_bananas")
    model.addConstr(3*x0 + 8*x1 + 7*x2 + 15*x3 <= 122, name="fiber_from_all")
    model.addConstr(12*x0 + 2*x1 <= 121, name="healthiness_from_cereal_salads_2")
    model.addConstr(12*x0 + 17*x3 <= 61, name="healthiness_from_cereal_sashimi_2")
    model.addConstr(2*x1 + 10*x2 <= 138, name="healthiness_from_salads_bananas_2")
    model.addConstr(12*x0 + 2*x1 + 17*x3 <= 101, name="healthiness_from_cereal_salads_sashimi_4")
    model.addConstr(12*x0 + 2*x1 + 10*x2 + 17*x3 <= 101, name="healthiness_from_all")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective value:", model.objVal)
        print("bowls of cereal:", x0.varValue)
        print("bagged salads:", x1.varValue)
        print("bananas:", x2.varValue)
        print("sashimi:", x3.varValue)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimize_problem()
