
from gurobipy import *

def solve_organization_problem():
    m = Model("Organization_Problem")

    Hank = m.addVar(vtype=GRB.INTEGER, name="Hank")
    Peggy = m.addVar(vtype=GRB.INTEGER, name="Peggy")
    Ringo = m.addVar(vtype=GRB.INTEGER, name="Ringo")
    George = m.addVar(vtype=GRB.INTEGER, name="George")
    Mary = m.addVar(vtype=GRB.INTEGER, name="Mary")
    Dale = m.addVar(vtype=GRB.INTEGER, name="Dale")

    # Add your constraints here
    # Example constraint
    m.addConstr(Hank + 2*Peggy + 3*George >= 57, name="Org_Score_Min")
    m.addConstr(10*Ringo + 20*George <= 368, name="Work_Quality_Max")

    # Objective function - For demonstration, minimize total hours worked
    m.setObjective(Hank + Peggy + Ringo + George + Mary + Dale, GRB.MINIMIZE)

    m.optimize()

solve_organization_problem()
