
import gurobi as gp
from gurobi import GRB

# Define variables
hours_worked_by_Hank = gp.Var(name='hours_worked_by_Hank', vtype=GRB.INTEGER)
hours_worked_by_Peggy = gp.Var(name='hours_worked_by_Peggy', vtype=GRB.INTEGER)
hours_worked_by_Ringo = gp.Var(name='hours_worked_by_Ringo', vtype=GRB.INTEGER)
hours_worked_by_George = gp.Var(name='hours_worked_by_George', vtype=GRB.INTEGER)
hours_worked_by_Mary = gp.Var(name='hours_worked_by_Mary', vtype=GRB.INTEGER)
hours_worked_by_Dale = gp.Var(name='hours_worked_by_Dale', vtype=GRB.INTEGER)

# Define model
model = gp.Model()

# Objective function
model.setObjective(4.9 * hours_worked_by_Hank + 5.94 * hours_worked_by_Peggy + 
                   7.72 * hours_worked_by_Ringo + 4.66 * hours_worked_by_George + 
                   3.27 * hours_worked_by_Mary + 1.6 * hours_worked_by_Dale, GRB.MINIMIZE)

# Constraints
# Work quality ratings
model.addConstr(1.93 * hours_worked_by_Hank <= 412)
model.addConstr(26.28 * hours_worked_by_Peggy <= 412)
model.addConstr(18.04 * hours_worked_by_Ringo <= 412)
model.addConstr(25.11 * hours_worked_by_George <= 412)
model.addConstr(23.64 * hours_worked_by_Mary <= 412)
model.addConstr(9.17 * hours_worked_by_Dale <= 412)

model.addConstr(12.03 * hours_worked_by_Hank <= 572)
model.addConstr(8.14 * hours_worked_by_Peggy <= 572)
model.addConstr(0.55 * hours_worked_by_Ringo <= 572)
model.addConstr(16.01 * hours_worked_by_George <= 572)
model.addConstr(11.17 * hours_worked_by_Mary <= 572)
model.addConstr(11.0 * hours_worked_by_Dale <= 572)

model.addConstr(16.87 * hours_worked_by_Hank <= 395)
model.addConstr(26.55 * hours_worked_by_Peggy <= 395)
model.addConstr(19.94 * hours_worked_by_Ringo <= 395)
model.addConstr(7.94 * hours_worked_by_George <= 395)
model.addConstr(19.26 * hours_worked_by_Mary <= 395)
model.addConstr(25.72 * hours_worked_by_Dale <= 395)

# Combined work quality ratings
model.addConstr(26.28 * hours_worked_by_Peggy + 23.64 * hours_worked_by_Mary >= 52)
model.addConstr(23.64 * hours_worked_by_Mary + 9.17 * hours_worked_by_Dale >= 24)
model.addConstr(25.11 * hours_worked_by_George + 9.17 * hours_worked_by_Dale >= 30)
model.addConstr(1.93 * hours_worked_by_Hank + 25.11 * hours_worked_by_George >= 64)
model.addConstr(1.93 * hours_worked_by_Hank + 23.64 * hours_worked_by_Mary >= 43)
model.addConstr(1.93 * hours_worked_by_Hank + 9.17 * hours_worked_by_Dale >= 66)
model.addConstr(25.11 * hours_worked_by_George + 23.64 * hours_worked_by_Mary + 9.17 * hours_worked_by_Dale >= 62)
model.addConstr(26.28 * hours_worked_by_Peggy + hours_worked_by_Dale * 9.17 >= 62)

# ... Add all constraints similarly

# Paperwork competence ratings
model.addConstr(12.03 * hours_worked_by_Hank + 16.01 * hours_worked_by_George >= 70)
model.addConstr(12.03 * hours_worked_by_Hank + 0.55 * hours_worked_by_Ringo + 16.01 * hours_worked_by_George >= 78)
model.addConstr(8.14 * hours_worked_by_Peggy + 16.01 * hours_worked_by_George + 11.0 * hours_worked_by_Dale >= 78)

# Organization scores
model.addConstr(16.87 * hours_worked_by_Hank + 7.94 * hours_worked_by_George >= 59)
model.addConstr(19.26 * hours_worked_by_Mary + 25.72 * hours_worked_by_Dale >= 65)
model.addConstr(26.55 * hours_worked_by_Peggy + 19.26 * hours_worked_by_Mary >= 55)

# Solve model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print('Optimal solution found.')
    print('Hours worked by Hank:', hours_worked_by_Hank.varValue)
    print('Hours worked by Peggy:', hours_worked_by_Peggy.varValue)
    print('Hours worked by Ringo:', hours_worked_by_Ringo.varValue)
    print('Hours worked by George:', hours_worked_by_George.varValue)
    print('Hours worked by Mary:', hours_worked_by_Mary.varValue)
    print('Hours worked by Dale:', hours_worked_by_Dale.varValue)
    print('Objective:', model.objVal)
else:
    print('No optimal solution found.')
