
from gurobipy import Model, GRB

# Create a new model
model = Model("maximize_food")

# Create variables
protein_bars = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
ham_sandwiches = model.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")

# Set objective function
model.setObjective(5.24 * protein_bars + 6.19 * ham_sandwiches, GRB.MAXIMIZE)

# Add constraints
model.addConstr(26 * protein_bars + 3 * ham_sandwiches >= 47, "umami_index_min")
model.addConstr(25 * protein_bars + 16 * ham_sandwiches >= 66, "iron_min")
model.addConstr(1 * protein_bars - 7 * ham_sandwiches >= 0, "protein_bars_vs_ham_sandwiches")

# Redundant constraints - these are already covered by the resource constraints
# model.addConstr(26 * protein_bars + 3 * ham_sandwiches <= 72, "umami_index_max1")
# model.addConstr(26 * protein_bars + 3 * ham_sandwiches <= 72, "umami_index_max2")
# model.addConstr(25 * protein_bars + 16 * ham_sandwiches <= 121, "iron_max1")
# model.addConstr(25 * protein_bars + 16 * ham_sandwiches <= 121, "iron_max2")


model.addConstr(26 * protein_bars + 3 * ham_sandwiches <= 112, "umami_index_resource_limit")
model.addConstr(25 * protein_bars + 16 * ham_sandwiches <= 136, "iron_resource_limit")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Number of protein bars: {protein_bars.x}")
    print(f"Number of ham sandwiches: {ham_sandwiches.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

