
import gurobipy as gp

# Create a new model
m = gp.Model("protein_bars_and_ham_sandwiches")

# Define the variables
protein_bars = m.addVar(name="protein_bars", integer=True)
ham_sandwiches = m.addVar(name="ham_sandwiches", integer=True)

# Objective function
m.setObjective(5.24 * protein_bars + 6.19 * ham_sandwiches, gp.GRB.MAXIMIZE)

# Umami index constraints
m.addConstraint(26 * protein_bars + 3 * ham_sandwiches >= 47, name="umami_min")
m.addConstraint(26 * protein_bars + 3 * ham_sandwiches <= 72, name="umami_max")

# Iron constraints
m.addConstraint(25 * protein_bars + 16 * ham_sandwiches >= 66, name="iron_min")
m.addConstraint(25 * protein_bars + 16 * ham_sandwiches <= 121, name="iron_max")

# Other constraints
m.addConstraint(protein_bars - 7 * ham_sandwiches >= 0, name="protein_vs_ham")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Protein Bars: {protein_bars.varValue}")
    print(f"Ham Sandwiches: {ham_sandwiches.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
