
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
bill = model.addVar(name="Bill", lb=0.0)
jean = model.addVar(name="Jean", lb=0.0)
bobby = model.addVar(name="Bobby", lb=0.0)
dale = model.addVar(name="Dale", lb=0.0)
paul = model.addVar(name="Paul", lb=0.0)

# Set objective function
model.setObjective(6.33 * bill + 3.95 * jean + 9.72 * bobby + 4.71 * dale + 1.45 * paul, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * jean + 7 * bobby >= 56, "c1")
model.addConstr(12 * bill + 7 * bobby >= 20, "c2")
model.addConstr(4 * jean + 10 * paul >= 22, "c3")
model.addConstr(12 * bill + 4 * jean >= 50, "c4")
model.addConstr(12 * bill + 8 * dale >= 52, "c5")
model.addConstr(12 * bill + 8 * dale + 10 * paul >= 42, "c6")
model.addConstr(4 * jean + 8 * dale + 10 * paul >= 42, "c7")
model.addConstr(12 * bill + 8 * dale + 10 * paul >= 54, "c8")
model.addConstr(4 * jean + 8 * dale + 10 * paul >= 54, "c9")
model.addConstr(12 * bill + 8 * dale <= 217, "c10")
model.addConstr(12 * bill + 4 * jean + 8 * dale <= 93, "c11")
model.addConstr(4 * jean + 8 * dale + 10 * paul <= 258, "c12")
model.addConstr(12 * bill + 7 * bobby + 8 * dale <= 236, "c13")
model.addConstr(12 * bill + 4 * jean + 7 * bobby <= 74, "c14")
model.addConstr(12 * bill + 7 * bobby + 10 * paul <= 212, "c15")
model.addConstr(12 * bill + 4 * jean + 10 * paul <= 127, "c16")
model.addConstr(7 * bobby + 8 * dale + 10 * paul <= 95, "c17")
model.addConstr(12 * bill + 4 * jean + 7 * bobby + 8 * dale + 10 * paul <= 95, "c18")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

