
from gurobipy import *

# Create a model
m = Model("Work_Optimization")

# Define variables
Bill = m.addVar(lb=0, name="hours_worked_by_Bill")
Jean = m.addVar(lb=0, name="hours_worked_by_Jean")
Bobby = m.addVar(lb=0, name="hours_worked_by_Bobby")
Dale = m.addVar(lb=0, name="hours_worked_by_Dale")
Paul = m.addVar(lb=0, name="hours_worked_by_Paul")

# Objective function
m.setObjective(6.33*Bill + 3.95*Jean + 9.72*Bobby + 4.71*Dale + 1.45*Paul, GRB.MAXIMIZE)

# Constraints
m.addConstr(12*Bill >= 0) # Not actually constraining anything since it's always true for positive hours worked
m.addConstr(4*Jean >= 0)
m.addConstr(7*Bobby >= 0)
m.addConstr(8*Dale >= 0)
m.addConstr(10*Paul >= 0)

# Minimum total combined work quality ratings
m.addConstr(4*Jean + 7*Bobby >= 56)
m.addConstr(12*Bill + 7*Bobby >= 20)
m.addConstr(4*Jean + 10*Paul >= 22)
m.addConstr(12*Bill + 4*Jean >= 50)
m.addConstr(12*Bill + 8*Dale >= 52)
m.addConstr(12*Bill + 8*Dale + 10*Paul >= 42)
m.addConstr(4*Jean + 8*Dale + 10*Paul >= 42)
m.addConstr(12*Bill + 8*Dale + 10*Paul >= 54)
m.addConstr(4*Jean + 8*Dale + 10*Paul >= 54)

# Maximum total combined work quality ratings
m.addConstr(12*Bill + 8*Dale <= 217)
m.addConstr(12*Bill + 4*Jean + 8*Dale <= 93)
m.addConstr(4*Jean + 8*Dale + 10*Paul <= 258)
m.addConstr(12*Bill + 7*Bobby + 8*Dale <= 236)
m.addConstr(12*Bill + 4*Jean + 7*Bobby <= 74)
m.addConstr(12*Bill + 7*Bobby + 10*Paul <= 212)
m.addConstr(12*Bill + 4*Jean + 10*Paul <= 127)
m.addConstr(7*Bobby + 8*Dale + 10*Paul <= 95)
m.addConstr(12*Bill + 4*Jean + 7*Bobby + 8*Dale + 10*Paul <= 95)

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
