
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x_B = m.addVar(name="hours_worked_by_Bill", lb=0)
x_J = m.addVar(name="hours_worked_by_Jean", lb=0)
x_Bo = m.addVar(name="hours_worked_by_Bobby", lb=0)
x_D = m.addVar(name="hours_worked_by_Dale", lb=0)
x_P = m.addVar(name="hours_worked_by_Paul", lb=0)

# Objective function
m.setObjective(6.33*x_B + 3.95*x_J + 9.72*x_Bo + 4.71*x_D + 1.45*x_P, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x_B <= 296/12, name="Bill_work_quality")
m.addConstr(x_J <= 296/4, name="Jean_work_quality")
m.addConstr(x_Bo <= 296/7, name="Bobby_work_quality")
m.addConstr(x_D <= 296/8, name="Dale_work_quality")
m.addConstr(x_P <= 296/10, name="Paul_work_quality")

m.addConstr(4*x_J + 7*x_Bo >= 56, name="Jean_Bobby_combined")
m.addConstr(12*x_B + 7*x_Bo >= 20, name="Bill_Bobby_combined")
m.addConstr(4*x_J + 10*x_P >= 22, name="Jean_Paul_combined")
m.addConstr(12*x_B + 4*x_J >= 50, name="Bill_Jean_combined")
m.addConstr(12*x_B + 8*x_D >= 52, name="Bill_Dale_combined")
m.addConstr(12*x_B + 8*x_D + 10*x_P >= 42, name="Bill_Dale_Paul_combined1")
m.addConstr(4*x_J + 8*x_D + 10*x_P >= 42, name="Jean_Dale_Paul_combined1")
m.addConstr(12*x_B + 8*x_D + 10*x_P >= 54, name="Bill_Dale_Paul_combined2")
m.addConstr(4*x_J + 8*x_D + 10*x_P >= 54, name="Jean_Dale_Paul_combined2")
m.addConstr(12*x_B + 8*x_D <= 217, name="Bill_Dale_combined_upper")
m.addConstr(12*x_B + 4*x_J + 8*x_D <= 93, name="Bill_Jean_Dale_combined_upper")
m.addConstr(4*x_J + 8*x_D + 10*x_P <= 258, name="Jean_Dale_Paul_combined_upper1")
m.addConstr(12*x_B + 7*x_Bo + 8*x_D <= 236, name="Bill_Bobby_Dale_combined_upper")
m.addConstr(12*x_B + 4*x_J + 7*x_Bo <= 74, name="Bill_Jean_Bobby_combined_upper")
m.addConstr(12*x_B + 7*x_Bo + 10*x_P <= 212, name="Bill_Bobby_Paul_combined_upper")
m.addConstr(12*x_B + 4*x_J + 10*x_P <= 127, name="Bill_Jean_Paul_combined_upper")
m.addConstr(7*x_Bo + 8*x_D + 10*x_P <= 95, name="Bobby_Dale_Paul_combined_upper")
m.addConstr(12*x_B + 4*x_J + 7*x_Bo + 8*x_D + 10*x_P <= 95, name="all_combined_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x_B.varValue)
    print("Hours worked by Jean: ", x_J.varValue)
    print("Hours worked by Bobby: ", x_Bo.varValue)
    print("Hours worked by Dale: ", x_D.varValue)
    print("Hours worked by Paul: ", x_P.varValue)
else:
    print("The model is infeasible")
