
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
chicken_drumsticks = m.addVar(vtype=GRB.INTEGER, name="chicken_drumsticks")
apple_pies = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
bowls_of_pasta = m.addVar(vtype=GRB.INTEGER, name="bowls_of_pasta")

# Set objective function
m.setObjective(3.28 * cantaloupes**2 + 6.66 * cantaloupes * apple_pies + 1.42 * cantaloupes * bowls_of_pasta + 6.84 * chicken_drumsticks**2 + 9.64 * chicken_drumsticks * bowls_of_pasta + 3.22 * apple_pies**2 + 4.23 * apple_pies * bowls_of_pasta + 2.46 * chicken_drumsticks, GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * cantaloupes**2 + 21 * bowls_of_pasta**2 >= 44, "calcium_constraint1")
m.addConstr(18 * apple_pies**2 + 21 * bowls_of_pasta**2 >= 64, "calcium_constraint2")
m.addConstr(15 * chicken_drumsticks + 18 * apple_pies + 21 * bowls_of_pasta >= 35, "calcium_constraint3")
m.addConstr(6 * cantaloupes + 15 * chicken_drumsticks + 21 * bowls_of_pasta >= 35, "calcium_constraint4")
m.addConstr(15 * chicken_drumsticks + 18 * apple_pies + 21 * bowls_of_pasta >= 61, "calcium_constraint5")
m.addConstr(6 * cantaloupes + 15 * chicken_drumsticks + 21 * bowls_of_pasta >= 61, "calcium_constraint6")
m.addConstr(6 * cantaloupes + 15 * chicken_drumsticks + 18 * apple_pies + 21 * bowls_of_pasta >= 61, "calcium_constraint7")
m.addConstr(-3 * apple_pies**2 + 2 * bowls_of_pasta**2 >= 0, "constraint8")
m.addConstr(6 * cantaloupes + 15 * chicken_drumsticks <= 175, "calcium_constraint9")
m.addConstr(6 * cantaloupes**2 + 15 * chicken_drumsticks**2 + 21 * bowls_of_pasta**2 <= 215, "calcium_constraint10")
m.addConstr(cantaloupes >=0)
m.addConstr(chicken_drumsticks >=0)
m.addConstr(apple_pies >=0)
m.addConstr(bowls_of_pasta >=0)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

