
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cantaloupes = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
    chicken_drumsticks = model.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)
    apple_pies = model.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
    bowls_of_pasta = model.addVar(name="bowls_of_pasta", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.28 * cantaloupes ** 2 + 6.66 * cantaloupes * apple_pies + 1.42 * cantaloupes * bowls_of_pasta +
                       6.84 * chicken_drumsticks ** 2 + 9.64 * chicken_drumsticks * bowls_of_pasta +
                       3.22 * apple_pies ** 2 + 4.23 * apple_pies * bowls_of_pasta + 2.46 * chicken_drumsticks,
                       gurobi.GRB.MINIMIZE)

    # Constraints
    # Calcium content
    model.addConstr(6 * cantaloupes + 15 * chicken_drumsticks + 18 * apple_pies + 21 * bowls_of_pasta <= 263)

    # Calcium constraints
    model.addConstr(cantaloupes ** 2 + bowls_of_pasta ** 2 >= 44)
    model.addConstr(apple_pies ** 2 + bowls_of_pasta ** 2 >= 64)
    model.addConstr(chicken_drumsticks + apple_pies + bowls_of_pasta >= 35)
    model.addConstr(cantaloupes + chicken_drumsticks + bowls_of_pasta >= 35)
    model.addConstr(chicken_drumsticks + apple_pies + bowls_of_pasta >= 61)
    model.addConstr(cantaloupes + chicken_drumsticks + bowls_of_pasta >= 61)
    model.addConstr(cantaloupes + chicken_drumsticks + apple_pies + bowls_of_pasta >= 61)

    # Additional constraints
    model.addConstr(-3 * apple_pies ** 2 + 2 * bowls_of_pasta ** 2 >= 0)
    model.addConstr(6 * cantaloupes + 15 * chicken_drumsticks <= 175)
    model.addConstr(cantaloupes ** 2 + chicken_drumsticks ** 2 + bowls_of_pasta ** 2 <= 215)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Cantaloupes: ", cantaloupes.varValue)
        print("Chicken Drumsticks: ", chicken_drumsticks.varValue)
        print("Apple Pies: ", apple_pies.varValue)
        print("Bowls of Pasta: ", bowls_of_pasta.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
