
import gurobipy as gp

# Create a new model
model = gp.Model("Employee_Scheduling")

# Create variables
laura_hours = model.addVar(lb=0, name="laura_hours")
george_hours = model.addVar(lb=0, name="george_hours")
john_hours = model.addVar(lb=0, name="john_hours")
peggy_hours = model.addVar(lb=0, name="peggy_hours")
mary_hours = model.addVar(lb=0, name="mary_hours")

# Set objective function
model.setObjective(3 * laura_hours + 4 * george_hours + 7 * john_hours + 6 * peggy_hours + 7 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints based on provided data
likelihood_to_quit = {'Laura': 9, 'George': 5, 'John': 20, 'Peggy': 8, 'Mary': 15}
productivity_rating = {'Laura': 17, 'George': 3, 'John': 11, 'Peggy': 11, 'Mary': 13}
dollar_cost_per_hour = {'Laura': 13, 'George': 5, 'John': 1, 'Peggy': 1, 'Mary': 16}
organization_score = {'Laura': 14, 'George': 2, 'John': 19, 'Peggy': 14, 'Mary': 8}
work_quality_rating = {'Laura': 3, 'George': 14, 'John': 6, 'Peggy': 9, 'Mary': 2}


model.addConstr(likelihood_to_quit['John'] * john_hours + likelihood_to_quit['Peggy'] * peggy_hours >= 34)
model.addConstr(likelihood_to_quit['Laura'] * laura_hours + likelihood_to_quit['John'] * john_hours >= 57)
model.addConstr(likelihood_to_quit['Laura'] * laura_hours + likelihood_to_quit['Peggy'] * peggy_hours >= 65)
model.addConstr(likelihood_to_quit['John'] * john_hours + likelihood_to_quit['Mary'] * mary_hours >= 32)
model.addConstr(likelihood_to_quit['Laura'] * laura_hours + likelihood_to_quit['Peggy'] * peggy_hours + likelihood_to_quit['Mary'] * mary_hours >= 41)

# ... (Similarly add all other constraints using the dictionaries)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

