
from gurobipy import Model, GRB

# Create a new model
m = Model("PlantOptimization")

# Create variables
chili_plants = m.addVar(vtype=GRB.INTEGER, name="chili_plants")
potato_vines = m.addVar(vtype=GRB.INTEGER, name="potato_vines")
pansies = m.addVar(vtype=GRB.INTEGER, name="pansies")
basil_plants = m.addVar(vtype=GRB.INTEGER, name="basil_plants")

# Set objective function
m.setObjective(6 * chili_plants + 3 * potato_vines + 6 * pansies + 5 * basil_plants, GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * chili_plants + 4 * potato_vines + 20 * pansies + 2 * basil_plants <= 195, "Planting Space")  # r0
m.addConstr(18 * chili_plants + 7 * potato_vines + 17 * pansies + 14 * basil_plants <= 298, "Beauty Rating")  # r1

m.addConstr(4 * potato_vines + 2 * basil_plants >= 37 * 144, "Potato Vines and Basil Plants Space")
m.addConstr(20 * chili_plants + 2 * basil_plants >= 17 * 144, "Chili Plants and Basil Plants Space")
m.addConstr(20 * chili_plants + 20 * pansies >= 43 * 144, "Chili Plants and Pansies Space")
m.addConstr(20 * pansies + 2 * basil_plants >= 16 * 144, "Pansies and Basil Plants Space")
m.addConstr(20 * chili_plants + 4 * potato_vines + 20 * pansies + 2 * basil_plants >= 16 * 144, "Total Planting Space")

m.addConstr(18 * chili_plants + 17 * pansies >= 65, "Chili Plants and Pansies Beauty")
m.addConstr(18 * chili_plants + 14 * basil_plants >= 63, "Chili Plants and Basil Plants Beauty")
m.addConstr(18 * chili_plants + 7 * potato_vines + 17 * pansies >= 53, "Chili Plants, Potato Vines, and Pansies Beauty 1")
m.addConstr(7 * potato_vines + 17 * pansies + 14 * basil_plants >= 53, "Potato Vines, Pansies, and Basil Plants Beauty 1")
m.addConstr(18 * chili_plants + 7 * potato_vines + 17 * pansies >= 61, "Chili Plants, Potato Vines, and Pansies Beauty 2")
m.addConstr(7 * potato_vines + 17 * pansies + 14 * basil_plants >= 61, "Potato Vines, Pansies, and Basil Plants Beauty 2")
m.addConstr(18 * chili_plants + 7 * potato_vines + 17 * pansies + 14 * basil_plants >= 61, "Total Beauty Rating")

m.addConstr(-10 * chili_plants + 9 * potato_vines >= 0, "Chili Plants and Potato Vines Relationship")
m.addConstr(3 * potato_vines - 10 * pansies >= 0, "Potato Vines and Pansies Relationship")

m.addConstr(7 * potato_vines + 14 * basil_plants <= 168, "Potato Vines and Basil Plants Beauty Limit")
m.addConstr(17 * pansies + 14 * basil_plants <= 230, "Pansies and Basil Plants Beauty Limit")
m.addConstr(18 * chili_plants + 17 * pansies + 14 * basil_plants <= 120, "Chili, Pansies, Basil Beauty Limit")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

