
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    chili_plants = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    potato_vines = model.addVar(name="potato_vines", vtype=gurobi.GRB.INTEGER)
    pansies = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
    basil_plants = model.addVar(name="basil_plants", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6 * chili_plants + 3 * potato_vines + 6 * pansies + 5 * basil_plants, gurobi.GRB.MINIMIZE)

    # Resource constraints
    model.addConstraint(20 * chili_plants + 4 * potato_vines + 20 * pansies + 2 * basil_plants <= 195 * 144)  # planting space in^2
    model.addConstraint(18 * chili_plants + 7 * potato_vines + 17 * pansies + 14 * basil_plants <= 298)  # beauty rating

    # Individual planting space constraints
    model.addConstraint(4 * potato_vines + 2 * basil_plants >= 37 * 144)  # potato vines and basil plants
    model.addConstraint(20 * chili_plants + 2 * basil_plants >= 17 * 144)  # chili plants and basil plants
    model.addConstraint(20 * chili_plants + 20 * pansies >= 43 * 144)  # chili plants and pansies
    model.addConstraint(20 * pansies + 2 * basil_plants >= 16 * 144)  # pansies and basil plants
    model.addConstraint(20 * chili_plants + 4 * potato_vines + 20 * pansies + 2 * basil_plants >= 16 * 144)  # total planting space

    # Beauty rating constraints
    model.addConstraint(18 * chili_plants + 17 * pansies >= 65)  # chili plants and pansies
    model.addConstraint(18 * chili_plants + 14 * basil_plants >= 63)  # chili plants and basil plants
    model.addConstraint(18 * chili_plants + 7 * potato_vines + 17 * pansies >= 53)  # chili plants, potato vines, and pansies
    model.addConstraint(7 * potato_vines + 17 * pansies + 14 * basil_plants >= 53)  # potato vines, pansies, and basil plants
    model.addConstraint(18 * chili_plants + 7 * potato_vines + 17 * pansies >= 61)  # chili plants, potato vines, and pansies
    model.addConstraint(7 * potato_vines + 17 * pansies + 14 * basil_plants >= 61)  # potato vines, pansies, and basil plants
    model.addConstraint(18 * chili_plants + 7 * potato_vines + 17 * pansies + 14 * basil_plants >= 61)  # total beauty rating

    # Additional constraints
    model.addConstraint(-10 * chili_plants + 9 * potato_vines >= 0)  
    model.addConstraint(3 * potato_vines - 10 * pansies >= 0)  
    model.addConstraint(7 * potato_vines + 14 * basil_plants <= 168)  
    model.addConstraint(17 * pansies + 14 * basil_plants <= 230)  
    model.addConstraint(18 * chili_plants + 17 * pansies + 14 * basil_plants <= 120)  

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chili plants: ", chili_plants.varValue)
        print("Potato vines: ", potato_vines.varValue)
        print("Pansies: ", pansies.varValue)
        print("Basil plants: ", basil_plants.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
