
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")

# Set objective function
m.setObjective(7 * potassium + 4 * vitamin_e + 1 * carbohydrates, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * potassium + 3 * vitamin_e >= 40, "c1")
m.addConstr(3 * vitamin_e + 5 * carbohydrates >= 27, "c2")
m.addConstr(9 * potassium + 5 * carbohydrates >= 25, "c3")
m.addConstr(9 * potassium + 3 * vitamin_e + 5 * carbohydrates >= 25, "c4")
m.addConstr(15 * vitamin_e + 13 * carbohydrates >= 50, "c5")
m.addConstr(14 * potassium + 15 * vitamin_e >= 51, "c6")
m.addConstr(14 * potassium + 15 * vitamin_e + 13 * carbohydrates >= 50, "c7")
m.addConstr(14 * potassium + 15 * vitamin_e + 13 * carbohydrates >= 50, "c8") # Redundant constraint
m.addConstr(10 * potassium - 7 * vitamin_e >= 0, "c9")
m.addConstr(-3 * vitamin_e + 9 * carbohydrates >= 0, "c10")
m.addConstr(9 * potassium + 3 * vitamin_e <= 65, "c11")
m.addConstr(9 * potassium + 5 * carbohydrates <= 73, "c12")
m.addConstr(9 * potassium + 3 * vitamin_e + 5 * carbohydrates <= 55, "c13")
m.addConstr(14 * potassium + 15 * vitamin_e + 13 * carbohydrates <= 87, "c14")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potassium:', potassium.x)
    print('vitamin_e:', vitamin_e.x)
    print('carbohydrates:', carbohydrates.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

