
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_potassium", lb=0)
x1 = m.addVar(name="milligrams_of_vitamin_E", lb=0)
x2 = m.addVar(name="grams_of_carbohydrates", lb=0)

# Objective function
m.setObjective(7 * x0 + 4 * x1 + x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(9 * x0 + 3 * x1 + 5 * x2 <= 121, name="energy_stability_index_r0")
m.addConstr(14 * x0 + 15 * x1 + 13 * x2 <= 169, name="immune_support_index_r1")

m.addConstr(9 * x0 >= 9 * x0, name="energy_stability_index_x0")
m.addConstr(3 * x1 >= 3 * x1, name="energy_stability_index_x1")
m.addConstr(5 * x2 >= 5 * x2, name="energy_stability_index_x2")

m.addConstr(14 * x0 >= 14 * x0, name="immune_support_index_x0")
m.addConstr(15 * x1 >= 15 * x1, name="immune_support_index_x1")
m.addConstr(13 * x2 >= 13 * x2, name="immune_support_index_x2")

m.addConstr(9 * x0 + 5 * x2 >= 40, name="energy_stability_index_min_1")
m.addConstr(3 * x1 + 5 * x2 >= 27, name="energy_stability_index_min_2")
m.addConstr(9 * x0 + 5 * x2 >= 25, name="energy_stability_index_min_3")
m.addConstr(9 * x0 + 3 * x1 + 5 * x2 >= 25, name="energy_stability_index_min_4")

m.addConstr(15 * x1 + 13 * x2 >= 50, name="immune_support_index_min_1")
m.addConstr(14 * x0 + 15 * x1 >= 51, name="immune_support_index_min_2")
m.addConstr(14 * x0 + 15 * x1 + 13 * x2 >= 50, name="immune_support_index_min_3")

m.addConstr(10 * x0 - 7 * x1 >= 0, name="linear_constraint_1")
m.addConstr(-3 * x1 + 9 * x2 >= 0, name="linear_constraint_2")

m.addConstr(9 * x0 + 3 * x1 <= 65, name="energy_stability_index_max_1")
m.addConstr(9 * x0 + 5 * x2 <= 73, name="energy_stability_index_max_2")
m.addConstr(9 * x0 + 3 * x1 + 5 * x2 <= 55, name="energy_stability_index_max_3")
m.addConstr(14 * x0 + 15 * x1 + 13 * x2 <= 87, name="immune_support_index_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of potassium: ", x0.varValue)
    print("Milligrams of vitamin E: ", x1.varValue)
    print("Grams of carbohydrates: ", x2.varValue)
else:
    print("The model is infeasible")
